<?php use Illuminate\Support\Carbon; ?>

<div class="card card-success table-responsive" >
    <div class="card-header text-center">
        <h5 class="m-0 text-white">Subscription List
            <a href="#" title="" data-toggle="modal" data-target="#subscription">
                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
            </a>
        </h5>
    </div>

    <!-- /.card-header -->
    <div class="card-body">
        <!-----------------------Active/Inactive Button--------------------->
        <table id="example3" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>SN</th>
                    <th>Details</th>
                    <th>Operator</th>
                    <th>Subscription Type</th>
                    <th width="9%">Billing Date</th>
                    <th width="9%">Alert Date</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th width="40%">Note</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $findSubscription; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($key+1); ?></td>
                    <td>
                        <a href="<?php echo e(url('subscription-details-'.$data->id)); ?>" target="_blank"><i class="fas fa-eye"></i></a>
                    </td>
                    <td><?php echo e($data->operator->name); ?></td>
                    <td><?php echo e($data->subsType->name); ?></td>
                    <td>
                        <?php echo e(Carbon::parse($data->billing_date)->translatedFormat('d')); ?>

                        <?php echo e(Carbon::parse($today)->translatedFormat('F,')); ?>

                        <?php echo e(Carbon::parse($today)->translatedFormat('Y')); ?>

                        
                    </td>
                    <td>
                        <?php echo e(Carbon::parse($data->alert_date)->translatedFormat('d')); ?>

                        <?php echo e(Carbon::parse($today)->translatedFormat('F,')); ?>

                        <?php echo e(Carbon::parse($today)->translatedFormat('Y')); ?>

                        
                    </td>
                    <td><?php echo e($data->amount); ?></td>
                    <td>
                        <?php if($data->alert_status == 1): ?>
                            <span class="badge badge-success">Active</span>
                        <?php elseif($data->alert_status == 0): ?>
                            <span class="badge badge-danger">Inactive</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($data->note); ?></td>
                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-info">Action</button>
                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                data-toggle="dropdown">
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <div class="dropdown-menu dropdown-content" role="menu">
                                <?php if(Auth::user()->role == 1 || Auth::user()->role == 2): ?>
                                    <?php if($data->alert_status == 1): ?>
                                        <a class="dropdown-item" data-toggle="modal" data-target="#pay-now"
                                            onclick="getDataID('<?php echo $data->id ?>')" href="#">
                                            <i class="fas fa-check" style="padding-right:10px;"></i> Pay Now</a>
                                    <?php endif; ?>
                                    <a class="dropdown-item" href="<?php echo e(url('subscription-details-'.$data->id)); ?>" target="_blank"><i class="fas fa-eye"
                                            style="padding-right:10px; "></i> Details</a>

                                    <a class="dropdown-item" data-toggle="modal" data-target="#subscription-edit"
                                        onclick="getDataSubs('<?php echo $data->id ?>')" href="#">
                                        <i class="fas fa-edit" style="padding-right:10px;"></i> Edit</a>
                                <?php endif; ?>
                                <?php if(Auth::user()->role == 1): ?>
                                    <?php $findPayment = App\Models\SubscriptionPayment::where('subscription_id', $data->id)->first(); ?>
                                    <?php if($findPayment == null): ?>
                                        <a class="dropdown-item" href="<?php echo e(url('destroy-subscription-'.$data->id)); ?>" id="delete">
                                            <i class="fas fa-trash" style="padding-right:10px; "></i> Delete</a>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <!-- /.card-body -->
</div>

<!-- /Add Subscription Modal Start -->
<div class="modal fade" id="subscription">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Subscription</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="createSubscriptionForm" action="<?php echo e(url('store-subscription')); ?>" enctype="multipart/form-data" method="post" style="padding: 10px;">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <div class="row form-group ">
                            <label class="col-md-4">Subscription Type <span class="text-danger">*</span></label>
                            <select class="col-md-8 form-control select2bs4" name="subscription_type_id" required="" style="width: 66.667%" >
                                <option value="" selected="" disabled="">Select Subscription Type</option>
                                <?php $__currentLoopData = $findSubsType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subsType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($subsType->id); ?>"><?php echo e($subsType->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Amount <span class="text-danger">*</span></label>
                            <input type="number" name="amount" id="subsAmount" min="0" step="0.0001" class="form-control col-md-8" placeholder="Amount" required>
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Billing Date <span class="text-danger">*</span></label>
                            <input type="date" name="billing_date" class="form-control col-md-8" min="<?php echo e($today); ?>" placeholder="Billing Date" required>
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-4">Alert Date <span class="text-danger">*</span></label>
                            <input type="date" name="alert_date" class="form-control col-md-8" min="<?php echo e($today); ?>" placeholder="Transaction Date" required>
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-4">Alert Status <span class="text-danger">*</span></label>
                            <select class="col-md-8 form-control select2bs4" name="alert_status" required="" style="width: 66.667%" >
                                <option value="" selected="" disabled="">Select Alert Status</option>
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-4">Note</label>
                            <textarea type="text" rows="5" name="note" class="form-control col-md-8" placeholder="Note"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary" id="createSubscriptionBtn">Submit</button>
                    </div>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /Add Subscription Modal End -->


<!-- /Edit Subscription Modal Start -->
<div class="modal fade" id="subscription-edit">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Update Subscription</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="updateSubscriptionForm" action="<?php echo e(url('update-subscriptions')); ?>" method="post" style="padding: 10px;">
                <?php echo csrf_field(); ?>
                <div class="modal-body">

                    <div class="form-group">
                        <div class="row form-group ">
                            <label class="col-md-4">Subscription Type </label>
                            <select class="col-md-8 form-control select" name="subscription_type_id" style="width: 66.667%" >
                                <option id="subsTypeName" selected="">Select Subscription Type</option>
                                <?php $__currentLoopData = $findSubsType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subsType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($subsType->id); ?>"><?php echo e($subsType->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Amount </label>
                             <input type="number" name="amount" id="amount" min="0" step="0.0001" class="form-control col-md-8" placeholder="Amount">
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Billing Date</label>
                            <input type="date" id="billing_date" name="billing_date" class="form-control col-md-8" min="<?php echo e($today); ?>" placeholder="Billing Date">
                        </div>
                        <div class="row form-group ">
                            <label class="col-md-4">Alert Date</label>
                            <input type="date" id="alert_date" name="alert_date" class="form-control col-md-8" min="<?php echo e($today); ?>" placeholder="Transaction Date">
                        </div>
                        <div class="row form-group ">
                            <label class="col-md-4">Alert Status</label>
                            <select class="col-md-8 form-control select" name="alert_status" style="width: 66.667%" >
                                <option id="alert_status" selected="">Select Alert Status</option>
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                        <div class="row form-group ">
                            <label class="col-md-4">Note</label>
                            <textarea type="text" id="notes" rows="5" name="note" class="form-control col-md-8" placeholder="Note"></textarea>
                        </div>
                        <input type="hidden" id="subID" name="id">
                        
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary" id="updateSubscriptionBtn">Update</button>
                    </div>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /Edit Subscription Modal End -->

<!-- / Pay Now Modal Start -->
<div class="modal fade" id="pay-now">
    <?php echo $__env->make('admin.page.accounts.administration.payTo.subscription.payNow', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<!-- / Pay Now Modal End -->

<script>
    $("#createSubscriptionBtn").click(function () {
        $(this).attr("disabled", "disabled");
        $('#createSubscriptionForm').submit();
        setTimeout('$("#createSubscriptionBtn").removeAttr("disabled")', 1500);
    });
    $("#updateSubscriptionBtn").click(function () {
        $(this).attr("disabled", "disabled");
        $('#updateSubscriptionForm').submit();
        setTimeout('$("#updateSubscriptionBtn").removeAttr("disabled")', 1500);
    });
</script>
<script type="text/javascript">
    function getDataSubs(subsId) {
        console.log(subsId);
        $.ajax({
            url: "findSubscriptionID", // path to function
            method: "GET",
            data: {

                subsId: subsId
            },
            dataType: "JSON",

            success: function(res) {

                console.log(res.note);

                $("#subID").val(res.id);
                $("#subscription_type_id").val(res.subscription_type_id);
                $("#subsTypeName").text(res.subsTypeName);
                $("#amount").val(res.amount);
                $("#billing_date").val(res.billing_date);
                $("#notes").val(res.note);
                $("#alert_date").val(res.alert_date);
                $("#alrtStatus").val(res.alert_status);

                if(res.alert_status == 1){
                    $("#alert_status").text('Active');
                }else{
                    $("#alert_status").text('Inactive');
                }
            },
        });
    }
</script>



<script type="text/javascript">
    $(document).ready(function () {
        $(document).on('keyup change','#subsAmount',function(){
            var accountsTotal = parseFloat($('#accountsTotal').val());
            var subsAmount = parseFloat($('#subsAmount').val());

            if( subsAmount > accountsTotal ) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'You can not Give more than Accounts Total Amount !!!',
                });

                $('#subsAmount').val(0.0);
            }
        });
    });

</script>


<script type="text/javascript">
    $(document).ready(function () {
        $(document).on('keyup change','#amount',function(){
            var accountsTotal = parseFloat($('#accountsTotal').val());
            console.log(accountsTotal);
            var amount = parseFloat($('#amount').val());

            if( amount > accountsTotal ) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'You can not Give more than Accounts Total Amount !!!',
                });

                $('#amount').val(0.0);
            }
        });
    });

</script>
<?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/accounts/administration/payTo/subscription/subscription.blade.php ENDPATH**/ ?>