<?php
    use Illuminate\Support\Carbon;
    $currentDate = Carbon::now();
    $date = strtotime($currentDate);
    $today = date('Y-m-d', $date);
    // echo $today;  strtotime(date('Y-m-d', $currentDate));
?>
<?php
    $currentURLs = URL::current(); // current url with domain name
    $currentURL = request()->path(); // current url without domain name
    // dd($currentURL);
    $findRole = DB::table('admin_role')->where('url', $currentURL)->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>



<?php $__env->startSection('title'); ?>
    Order Payment Received List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php if(!empty($findRole->url)): ?>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-success table-responsive" style="margin-top:20px;">

                        <div class="card-header text-center">
                            <h5 class="m-0 text-white">Order Payment Received List
                                <a href="<?php echo e(url('view-system-config')); ?>">
                                    <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                                </a>
                            </h5>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">

                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Operator</th>
                                        <th>Order Id</th>
                                        <th>Service Type</th>
                                        <th>Payment Method</th>
                                        <th>Amount</th>
                                        <th>Charge</th>
                                        <th>Total</th>
                                        <th>Transaction Date</th>
                                        <th>System Date</th>
                                        <th>Status</th>
                                        <th>Note</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $total = 0;
                                    ?>
                                    <?php $__currentLoopData = $spendMoney; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$spend): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key+1); ?></td>
                                        <td>
                                            <?php if($spend->created_by != null): ?>
                                                <?php echo e($spend->operator->name); ?>

                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($spend->order_id != null): ?>
                                                <?php echo e($spend->order->order_unique_id); ?>

                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($spend->order_id != null): ?>
                                                <?php echo e($spend->order->service->name); ?>

                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($spend->payment_method_id != null): ?>
                                                <?php echo e($spend->payMethod->name); ?>

                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($spend->payment_amount); ?></td>
                                        <td><?php echo e($spend->charge); ?></td>
                                        <td><?php echo e($spend->payment_amount - $spend->charge); ?></td>
                                        <td><?php echo e($spend->trans_date); ?></td>
                                        <td><?php echo e($spend->created_at); ?></td>
                                        <td>
                                            <?php if($spend->status ==3): ?><span class="textSize badge badge-warning">Pending</span>
                                            <?php elseif($spend->status ==4): ?><span class="textSize badge badge-danger">Decline</span>
                                            <?php elseif($spend->status == 2 || $spend->status == 1 ): ?><span class="textSize badge badge-success">Successful</span>
                                            <?php else: ?><span class="badge">N/A</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($spend->note); ?></td>
                                        <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">
                                                <?php if(Auth::user()->role == 1 || Auth::user()->role == 2): ?>

                                                <?php if($spend->status == 3 ): ?>
                                                <a class="dropdown-item text-success" id="accept"
                                                    href="<?php echo e(url('client-order-pay-accept-'.$spend->id)); ?>"><span
                                                        class="fa fa-check" style="padding-right:10px;"></span>
                                                    Accept</a>
                                                <a class="dropdown-item text-danger" id="declined"
                                                    href="<?php echo e(url('client-order-pay-declined-'.$spend->id)); ?>"><span
                                                        class="fas fa-times" style="padding-right:10px;"></span>
                                                    Declined</a>
                                                <?php endif; ?>
                                                
                                                <?php endif; ?>
                                                
                                            </div>
                                        </div>
                                    </td>
                                    </tr>

                                    <?php $total = $total + $spend->payment_amount ; ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

    <?php else: ?>
        <?php echo $__env->make('admin.404', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.masterBlade', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/accounts/administration/budgetReceived/spendMoney.blade.php ENDPATH**/ ?>