<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">Budget Received</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>

        <form id="createBudgetReceiveForm" action="<?php echo e(url('store-budget-received')); ?>" enctype="multipart/form-data" method="post" style="padding: 10px">
            <?php echo csrf_field(); ?>
            <div class="modal-body">

                <div class="form-group">

                    <div class="row form-group ">
                        <label class="col-md-5">Select Clients <span class="text-danger">*</span></label>
                        <select class="col-md-7 form-control select2bs4" name="client_id" required="" style="width: 58.333%" >
                            <option value="" selected="" disabled="">Select Clients</option>
                            <?php $__currentLoopData = $getClients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($client->id); ?>"><?php echo e($client->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="row form-group ">
                        <label class="col-md-5">Payment Methods <span class="text-danger">*</span></label>
                        <select class="col-md-7 form-control select2bs4" name="payment_method_id" required="" style="width: 58.333%" >
                            <option value="" selected="" disabled="">Select Payment Methods</option>
                            <?php $__currentLoopData = $findPaymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($datas->id); ?>"><?php echo e($datas->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Transaction ID</label>
                        <input type="text" name="transactionID" class="form-control col-md-7" placeholder="Transaction ID">
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Received Amount ($) <span class="text-danger">*</span></label>
                        <input type="number" name="received_amount" id="received_amount" min="0" step="0.0001" class="form-control col-md-7" placeholder="Received Amount ($)" required>
                    </div>
                    

                    <div class="row form-group ">
                        <label class="col-md-5">Transaction Date <span class="text-danger">*</span></label>
                        <input type="date" name="trans_date" class="form-control col-md-7" max="<?php echo e($today); ?>" placeholder="Transaction Date" required>
                    </div>
                    <div class="row form-group ">
                        <label class="col-md-5">Note</label>
                        <textarea type="text" rows="5" name="note" class="form-control col-md-7" placeholder="Note"></textarea>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="createBudgetReceiveBtn">Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->



<script type="text/javascript">
    $(document).ready(function () {
        $(document).on('keyup change','#received_amount, #charge, #total_amount ',function(){
            var received_amount = parseFloat($('#received_amount').val());
            var charge = parseFloat($('#charge').val());

            console.log(charge);

            var total_amount = parseFloat(received_amount - charge).toFixed(4);

            $('#total_amount').val(total_amount);

        });
    });

</script>
<?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/accounts/administration/budgetReceived/addbudget.blade.php ENDPATH**/ ?>