<div class="card card-success table-responsive" >
    <div class="card-header text-center">
        <h5 class="m-0 text-white">Employee Salary List
            <a href="#" title="" data-toggle="modal" data-target="#modal-default">
                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
            </a>
        </h5>
    </div>

    <!-- /.card-header -->
    <div class="card-body">
        <!-----------------------Active/Inactive Button--------------------->

        <table id="example1" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>SN</th>
                    <th>Operator</th>
                    <th>Name</th>
                    <th>Payment Method</th>
                    <th>Month of Salary</th>
                    <th>Salary</th>
                    <th>Bonus</th>
                    <th>Total</th>
                    <th>Transaction Date</th>
                    <th>System Date</th>
                    <th>Note</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $findEmployeeSalary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($key+1); ?></td>
                    <td><?php echo e($data->operator->name); ?></td>
                    <td><?php echo e($data->employee->name); ?></td>
                    <td><?php echo e($data->payMethod->name); ?></td>
                    <td>
                        <?php if($data->month_of_salary != null): ?>
                            <?php echo e(date('F - Y', strtotime($data->month_of_salary))); ?>

                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </td>

                    <td><?php echo e($data->salary); ?></td>
                    <td><?php echo e($data->bonus); ?></td>
                    <td><?php echo e($data->total_salary); ?></td>
                    <td><?php echo e($data->trans_date); ?></td>
                    <td><?php echo e($data->created_at); ?></td>
                    <td><?php echo e($data->note); ?></td>
                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-info">Action</button>
                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                data-toggle="dropdown">
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <div class="dropdown-menu dropdown-content" role="menu">
                                <?php if(Auth::user()->role == 1 || Auth::user()->role == 2): ?>
                                    <a class="dropdown-item" data-toggle="modal" data-target="#modal-default-edit"
                                        onclick="getDataA('<?php echo $data->id ?>')" href="#">
                                        <i class="fas fa-edit" style="padding-right:10px;"></i> Edit</a>

                                <?php endif; ?>
                                <?php if(Auth::user()->role == 1): ?>
                                    <a class="dropdown-item" href="<?php echo e(url('destroy-employee-salary-'.$data->id)); ?>" id="delete">
                                        <i class="fas fa-trash" style="padding-right:10px; "></i> Delete</a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <!-- /.card-body -->
</div>

<!-- /Add Employee Salary Modal Start -->
<div class="modal fade" id="modal-default">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Employee Salary</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="addSalaryForm" action="<?php echo e(url('store-employee-salary')); ?>" enctype="multipart/form-data" method="post" style="padding: 10px">
                <?php echo csrf_field(); ?>
                <div class="modal-body">

                    <div class="form-group">
                        <div class="row form-group ">
                            <label class="col-md-4">Employee Name <span class="text-danger">*</span></label>
                            <select class="col-md-8 form-control select2bs4" name="employee_id" required="" style="width: 66.667%"
                            onchange="getSalary(this.value)" >
                                <option value="" selected="" disabled="">Select Employee</option>
                                <?php $__currentLoopData = $findEmployee; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($data->id); ?>"><?php echo e($data->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <?php if($accountsTotal != null): ?>
                        <input type="hidden" id="accountsTotal" value="<?php echo e($accountsTotal->total); ?>">
                        <?php else: ?>
                        <input type="hidden" id="accountsTotal" value="">
                        <?php endif; ?>


                        <div class="row form-group">
                            <label class="col-md-4">Transaction ID</label>
                            <input type="text" name="transactionID" class="form-control col-md-8" placeholder="Transaction ID">
                        </div>

                        <div class="row form-group">
                            <label class="col-md-4">Month Of Salary <span class="text-danger">*</span></label>
                            <input type="month" name="month_of_salary" class="form-control col-md-8" required placeholder="Month Of Salary">
                        </div>

                        <div class="row form-group">
                            <label class="col-md-4">Salary <span class="text-danger">*</span></label>
                            <input type="number" name="salary" id="salary" class="form-control col-md-8" placeholder="Salary" readonly>
                        </div>

                        <div class="row form-group ">
                            <span style="color :red; " id="showTotalAmount"></span>
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Bonus</label>
                            <input type="number" name="bonus" id="bonus" min="0" step="0.01" class="form-control col-md-8"  placeholder="Bonus">
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Total</label>
                            <input type="number" id="total" class="form-control col-md-8" readonly>
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-4">Payment Methods <span class="text-danger">*</span></label>
                            <select class="col-md-8 form-control select2bs4" name="payment_method_id" required="" style="width: 66.667%" >
                                <option value="" selected="" disabled="">Select Payment Methods</option>
                                <?php $__currentLoopData = $findPaymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($datas->id); ?>"><?php echo e($datas->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-4">Transaction Date <span class="text-danger">*</span></label>
                            <input type="date" name="trans_date" class="form-control col-md-8" max="<?php echo e($today); ?>" placeholder="Transaction Date" required>
                        </div>
                        <div class="row form-group ">
                            <label class="col-md-4">Note</label>
                            <textarea type="text" rows="5" name="note" class="form-control col-md-8" placeholder="Note"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" id="addSalaryButton" class="btn btn-primary">Submit</button>
                    </div>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /Add Employee Salary Modal End -->

<!-- /Edit Employee Salary Modal Start -->
<div class="modal fade" id="modal-default-edit">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Employee Salary Update</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="updateSalaryForm" action="<?php echo e(url('update-employee-salary')); ?>" enctype="multipart/form-data" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-body">

                    <div class="form-group">
                        <div class="row form-group ">
                            <label class="col-md-4">Employee Name </label>
                            <input type="text" id="employeeName" class="form-control col-md-8" readonly>
                            
                        </div>


                        <div class="row form-group">
                            <label class="col-md-4">Transaction ID</label>
                            <input type="text" name="transactionID" id="transactionID" class="form-control col-md-8" placeholder="Transaction ID">
                        </div>

                        <div class="row form-group">
                            <label class="col-md-4">Month Of Salary</label>
                            <input type="month" name="month_of_salary" id="month_of_salary" class="form-control col-md-8">
                        </div>

                        <div class="row form-group">
                            <label class="col-md-4">Salary </label>
                            <input type="number" name="salary" id="main_salary" class="form-control col-md-8" placeholder="Salary" readonly>
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Bonus</label>
                            <input type="number" name="bonus" id="bonuses" class="form-control col-md-8"  placeholder="Bonus">
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Total</label>
                            <input type="number" id="totalss" class="form-control col-md-8" readonly>
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-4">Payment Methods</label>
                            <select class="col-md-8 form-control select" name="payment_method_id" style="width: 66.667%" >
                                <option id="payment_method_id" selected="" >Select Payment Methods</option>
                                <?php $__currentLoopData = $findPaymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($datas->id); ?>"><?php echo e($datas->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-4">Transaction Date </label>
                            <input type="date" name="trans_date" id="trans_date" class="form-control col-md-8" max="<?php echo e($today); ?>" placeholder="Transaction Date" required>
                        </div>
                        <div class="row form-group ">
                            <label class="col-md-4">Note</label>
                            <textarea type="text" rows="5" name="note" id="note" class="form-control col-md-8" placeholder="Note"></textarea>
                        </div>
                        <input type="hidden" name="id" id="id">
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary" id="updateSalaryButton">Update</button>
                    </div>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /Edit Employee Salary Modal End -->
<script>
    $("#addSalaryButton").click(function () {
        $(this).attr("disabled", "disabled");
        $('#addSalaryForm').submit();
        setTimeout('$("#addSalaryButton").removeAttr("disabled")', 1500);
    });
    $("#updateSalaryButton").click(function () {
        $(this).attr("disabled", "disabled");
        $('#updateSalaryForm').submit();
        setTimeout('$("#updateSalaryButton").removeAttr("disabled")', 1500);
    });
</script>
<script type="text/javascript">
    function getSalary(emplyID) {
        // console.log(subMenu_id);
        $.ajax({
            url: "findEmployeeSalary", // path to function
            method: "GET",
            data: {

                emplyID: emplyID
            },
            dataType: "JSON",

            success: function(res) {

                var accountsTotal = parseFloat($('#accountsTotal').val());
                console.log(accountsTotal);

                if( res.salary > accountsTotal ) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'You can not Give more than Accounts Total Amount !!!',
                    });

                    $("#salary").val(res.salary);
                    $('#bonus').val(0.0);
                    $('#total').val(res.salary);
                    $("#addSalaryButton").attr('disabled','disabled');
                    $("#showTotalAmount").html('<span style="padding-left:10px; font-wight:bold;">Current Accounts Total Amount : '+accountsTotal+'</span>');
                }else{
                    $("#salary").val(res.salary);
                    $('#bonus').val(0.0);
                    $('#total').val(res.salary);
                    $("#addSalaryButton").removeAttr('disabled');
                    $("#showTotalAmount").html('<span style="padding-left:10px; font-wight:bold;">Current Accounts Total Amount : '+accountsTotal+'</span>');
                }
                if( res.salary == null ){
                    $("#showTotalAmount").html('<span style="padding-left:10px; font-wight:bold;">Salary must be greater than 0.</span>');
                    $("#addSalaryButton").attr('disabled','disabled');
                }
            },
        });
    }
</script>

<script type="text/javascript">
    function getDataA(salryID) {
        // console.log(subMenu_id);
        $.ajax({
            url: "findEmployeeSalaryID", // path to function
            method: "GET",
            data: {

                salryID: salryID
            },
            dataType: "JSON",

            success: function(res) {

                console.log(res.employeeName);

                $("#id").val(res.id);
                $("#main_salary").val(res.salary);
                $("#transactionID").val(res.transactionID);
                $("#bonuses").val(res.bonus);
                $("#trans_date").val(res.trans_date);
                $("#note").text(res.note);
                $("#employeeName").val(res.employeeName);
                $("#payment_method_id").text(res.payMethod);
                $('#totalss').val(res.total_salary);
            },
        });
    }
</script>



<script type="text/javascript">
    $(document).ready(function () {
        $(document).on('keyup change','#bonus, #total, #salary',function(){
            var accountsTotal = parseFloat($('#accountsTotal').val());
            var salary = parseFloat($('#salary').val());
            var bonus = parseFloat($('#bonus').val());

            // console.log(salary);

            var total = salary + bonus;

            if( total > accountsTotal ) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'You can not Give more than Accounts Total Amount !!!',
                });

                $('#bonus').val(0.0);
                $('#total').val(salary);
            }else{
                $('#bonus').val(bonus);
                $('#total').val(total);
            }
        });
    });

</script>



<script type="text/javascript">

    $(document).ready(function () {
        $(document).on('keyup change','#bonuses, #totalss, #main_salary',function(){
            var accountsTotal = parseFloat($('#accountsTotal').val());
            var main_salary = parseFloat($('#main_salary').val());
            var bonuses = parseFloat($('#bonuses').val());

            // console.log(main_salary);

            var totalss = main_salary + bonuses;

            if( totalss > accountsTotal ) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'You can not Give more than Accounts Total Amount !!!',
                });

                $('#bonuses').val(0.0);
                $('#totalss').val(main_salary);
            }else{
                $('#bonuses').val(bonuses);
                $('#totalss').val(totalss);
            }
        });
    });

</script>

<?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/accounts/administration/payTo/employeeSalary.blade.php ENDPATH**/ ?>