<div class="card card-success table-responsive" >
    <div class="card-header text-center">
        <h5 class="m-0 text-white">Vendor Payment List
            <a href="#" title="" data-toggle="modal" data-target="#vendor-payments">
                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
            </a>
        </h5>
    </div>

    <!-- /.card-header -->
    <div class="card-body">
        <!-----------------------Active/Inactive Button--------------------->
        <table id="example2" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>SN</th>
                    <th>Operator</th>
                    <th>Vendor Name</th>
                    <th>Assign ID</th>
                    <th>Order ID</th>
                    <th>Service Type</th>
                    <th>Receivable Amount</th>
                    <th>Total Received</th>
                    <th>Total Due</th>
                    <th>Trans Date</th>
                    <th>System Date</th>
                    <th>Note</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $getVendorSalary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($key+1); ?></td>
                    <td><?php echo e($data->operator->name); ?></td>
                    <td><?php echo e($data->vendor->name); ?></td>
                    <td><?php echo e($data->assign->unique_id); ?></td>
                    <td><?php echo e($data->order->order_unique_id); ?></td>
                    <td><?php echo e($data->order->service->name); ?></td>
                    <td><?php echo e($data->amount); ?></td>
                    <td><?php echo e($data->pay); ?></td>
                    <td><?php echo e($data->due); ?> </td>
                    <td><?php echo e($data->trans_date); ?></td>
                    <td><?php echo e($data->created_date); ?></td>
                    <td><?php echo e($data->note); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <!-- /.card-body -->
</div>


<!-- /Add Vendor Payments Modal Start -->
<div class="modal fade" id="vendor-payments">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Vendor Payments</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="v-form" action="<?php echo e(url('store-vendor-payment')); ?>" enctype="multipart/form-data" method="post" style="padding: 10px">
                <?php echo csrf_field(); ?>
                <div class="modal-body">

                    <div class="form-group">
                        <div class="row form-group ">
                            <label class="col-md-4">Vendor Name <span class="text-danger">*</span></label>
                            <select class="col-md-8 form-control select2bs4" id="findVendors" required="" style="width: 66.667%"
                            onchange="findVendorID(this.value)" >
                                <option value="" selected="" disabled="">Select Vendor</option>
                                <?php $__currentLoopData = $findVendor; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($data->role == 4): ?>
                                        <option value="<?php echo e($data->ven_Emp_id); ?>"><?php echo e($data->vendorName); ?></option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-4">Assign Order <span class="text-danger">*</span> </label>
                            <select class="form-control col-md-8 " name="assign_id" id="subcategoryi" required="" style="width: 66.667%"
                            onchange="assignDetails(this.value)" >
                                <option value="">Select Assign Order</option>
                            </select>
                        </div>


                        <?php if($accountsTotal != null): ?>
                        <input type="hidden" id="acntTotal" value="<?php echo e($accountsTotal->total); ?>">
                        <?php else: ?>
                        <input type="hidden" id="acntTotal" value="">
                        <?php endif; ?>

                        <div class="row form-group">
                            <label class="col-md-4">Transaction ID</label>
                            <input type="text" name="transactionID" id="transactionID" class="form-control col-md-8" placeholder="Transaction ID">
                        </div>

                        <div class="row form-group">
                            <label class="col-md-4">Amount <span class="text-danger">*</span></label>
                            <input type="number" name="vendorSalary" id="vendorSalary" step="0.0001" min="0" value="0" class="form-control col-md-8" placeholder="Amount" readonly>
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-4">Payment From <span class="text-danger">*</span></label>
                            <select class="col-md-8 form-control select" name="payment_from" id="payment_from" required="" style="width: 66.667%"
                            onchange="getPaymentForm(this.value)" >
                                <option value="" selected="" disabled="">Select Payment From</option>
                                <!--<option value="1">Main Accounts</option>-->
                                <option value="2">Risk Fund</option>
                                <option value="3">Vendor Account</option>
                            </select>
                        </div>
                        <div class="row form-group ">
                            <span style="color :red; " id="showaTotalAmount"></span>
                        </div>

                        <div class="row form-group">
                            <label class="col-md-4">Pay</label>
                            <input type="number" name="vendorPay" id="vendorPay" step="0.0001" min="0.01" value="0" class="form-control col-md-8"  placeholder="Pay">
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Due</label>
                            <input type="number" name="totalDue" id="totalDue" step="0.0001" min="0" value="0" class="form-control col-md-8" readonly>
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-4">Payment Methods <span class="text-danger">*</span></label>
                            <select class="col-md-8 form-control select2bs4" name="payment_method_id" id="payment_method_id" required="" style="width: 66.667%" >
                                <option value="" selected="" disabled="">Select Payment Methods</option>
                                <?php $__currentLoopData = $findPaymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($datas->id); ?>"><?php echo e($datas->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-4">Transaction Date <span class="text-danger">*</span></label>
                            <input type="date" name="trans_date" id="trans_date" class="form-control col-md-8" max="<?php echo e($today); ?>" placeholder="Transaction Date" required>
                        </div>
                        <div class="row form-group ">
                            <label class="col-md-4">Note</label>
                            <textarea type="text" rows="5" name="note" class="form-control col-md-8" placeholder="Note"></textarea>
                        </div>

                        <input type="hidden" name="vendor_id" id="vendorsIDs">
                        <input type="hidden" name="order_id" id="ordersIDs">
                        <input type="hidden" id="currentTotalBalance">
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary" id="vendorPaymentSubmit">Submit</button>
                    </div>
                </div>
            </form>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /Add Vendor Payments Modal End -->

<script type="text/javascript">
    $("#vendorPaymentSubmit").click(function () {
        $(this).attr("disabled", "disabled");
        $('#v-form').submit();
        setTimeout('$("#vendorPaymentSubmit").removeAttr("disabled")', 1500);
    });
    function findVendorID(findID) {
        
        $.ajax({
            url: "findAssignOrder", // path to function
            method: "GET",
            data: {

                findID: findID
            },
            dataType: "JSON",

            success: function(res) {
                
                if(res ){
                    $("#subcategoryi").empty();

                    $("#subcategoryi").append('<option>Select Assign Order</option>');
                    $.each(res,function(key,value){
                        $("#subcategoryi").append('<option value="'+key+'">'+value+'</option>');
                    });
                }else{
                    $("#subcategoryi").empty();
                }
            },
        });
    }
</script>

<script type="text/javascript">
    function assignDetails(assignID) {
       
        $.ajax({
            url: "findAssignDetails", // path to function
            method: "GET",
            data: {

                assignID: assignID
            },
            dataType: "JSON",

            success: function(res) {

                if(res.work_status == 7){
                    $("#totalDue").val(res.total_earn - res.total_pay);

                    if(res.total_due > 0){
                        $("#vendorSalary").val(res.total_earn - res.total_pay);
                    }else{
                        $("#vendorSalary").val(res.total_earn);
                    }
                }else{

                    $("#vendorSalary").val(res.total_earn - res.total_pay);
                    $("#totalDue").val(res.total_earn - res.total_pay);
                }

                $("#vendorsIDs").val(res.ven_Emp_id);
                $("#ordersIDs").val(res.order_id);
            },
        });

        $.ajax({
            url: "findOrderDetails", // path to function
            method: "GET",
            data: {

                assignID: assignID
            },
            dataType: "JSON",

            success: function(val) {

                Swal.fire({
                    title: 'Order Details',
                    html: '<p style="font-size:20px;"><b>Order Unique ID: </b>'+val.order_unique_id+' ,<b> Service Type: </b>'+val.service_type_id+
                        ' , <b>Platform:</b> '+val.platform+' ,<b>Geo: </b> '+val.geo+' , <b>Target Date: </b>'+val.target_date+
                        ' , <b>Quantity: </b>'+val.total_quantity+' , <b>Rate: </b>'+val.service_cost+' , <b>Total Budget: </b>'+val.total_budget+' </p> ',
                });
            },
        });
    }
</script>

<script type="text/javascript">
    function getPaymentForm(payFormValue) {
        
        $.ajax({
            url: "getPaymentFormDetails", // path to function
            method: "GET",
            data: {
                vendor_id: $("#findVendors").val(),
                payFormValue: payFormValue
            },
            dataType: "JSON",

            success: function(result) {

                if(payFormValue == 3){

                    if (result != 0) {
                        $("#showaTotalAmount").html('<span style="padding-left:10px; font-wight:bold;">Current Vendor Account Balance is : ' + result.current_balance + '</span>');
                        $("#showaTotalAmount").attr('data-id', result.current_balance);
                        $("#currentTotalBalance").val(result.current_balance);
                    } else {
                        var result = 0;
                        $("#showaTotalAmount").html('<span style="padding-left:10px; font-wight:bold;">Current Vendor Account Balance is : ' + result + '</span>');
                        $("#showaTotalAmount").attr('data-id', result);
                        $("#currentTotalBalance").val(result);
                    }

                }else{
                    if (result.total > 0) {
                        $("#showaTotalAmount").html('<span style="padding-left:10px; font-wight:bold;">Current Main Account/Risk Fund Balance is : ' + result.total + '</span>');
                        $("#showaTotalAmount").attr('data-id', result.total);
                        $("#currentTotalBalance").val(result.total);
                    } else {
                        var result = 0;
                        $("#showaTotalAmount").html('<span style="padding-left:10px; font-wight:bold;">Current Main Account/Risk Fund Balance is : ' + result + '</span>');
                        $("#showaTotalAmount").attr('data-id', result);
                        $("#currentTotalBalance").val(result);
                    }
                }

            },
        });
    }
</script>

<script type="text/javascript">
    $(document).ready(function () {

        var vendorPayAmount = parseFloat($('#vendorPay').val());
        if(vendorPayAmount == 0 || vendorPayAmount < 0 ){
            document.querySelector('#vendorPaymentSubmit').disabled = true;
        }else{
            document.querySelector('#vendorPaymentSubmit').disabled = false;
        }
        
        $(document).on('keyup change','#acntTotal, #vendorSalary, #vendorPay, #totalDue, #findVendors, #payment_from',function(){
            var acntTotal = parseFloat($('#acntTotal').val());
            var vendorSalary = parseFloat($('#vendorSalary').val());
            var vendorPay = parseFloat($('#vendorPay').val());
            var currentTotalBalance = parseFloat($('#currentTotalBalance').val());

            var totalDue = parseFloat(vendorSalary - vendorPay).toFixed(4);

            if( vendorPay > vendorSalary || vendorPay > currentTotalBalance) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'You can not Give more than Accounts Total Amount !!!',
                });

                $('#vendorPay').val(0.0);
                $('#totalDue').val(0.0);

            }else{
                $('#totalDue').val(totalDue);
                $('#vendorSalary').val(vendorSalary);
            }


            if(vendorPay == 0 || vendorPay < 0 ){
                document.querySelector('#vendorPaymentSubmit').disabled = true;
            }else{
                document.querySelector('#vendorPaymentSubmit').disabled = false;
            }
        });

    });

</script>


<script type="text/javascript">
    $(document).ready(function () {

        $(document).on('keyup change','#findVendors, #subcategoryi, #acntTotal, #transactionID, #vendorSalary, #payment_from, #vendorPay, #payment_method_id, #trans_date', function(){

            var vendorPayAmounts = parseFloat($('#vendorPay').val());
            var vendorSalary = parseFloat($('#vendorSalary').val());

            if(vendorPayAmounts == 0 || vendorSalary < 1 ){
                document.querySelector('#vendorPaymentSubmit').disabled = true;
            }else{
                document.querySelector('#vendorPaymentSubmit').disabled = false;
            }
        });

    });

</script>




<?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/accounts/administration/payTo/vendorPayment.blade.php ENDPATH**/ ?>