<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">Update Budget Received</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>

        <form id="updateBudgetReceiveForm" action="<?php echo e(url('update-budget-received')); ?>" enctype="multipart/form-data" method="post" style="padding: 10px">
            <?php echo csrf_field(); ?>
            <div class="modal-body">

                <div class="form-group">

                    <input type="hidden" name="id" id="receBId">

                    <div class="row form-group ">
                        <label class="col-md-5">Select Clients <span class="text-danger">*</span></label>
                        <select class="col-md-7 form-control select" name="client_id" required="" style="width: 58.333%" >
                            <option id="clientName" selected="" >Select Clients</option>
                            <?php $__currentLoopData = $getClients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($client->id); ?>"><?php echo e($client->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="row form-group ">
                        <label class="col-md-5">Payment Methods <span class="text-danger">*</span></label>
                        <select class="col-md-7 form-control select" name="payment_method_id" required="" style="width: 58.333%" >
                            <option id="payMethodName" selected="" >Select Payment Methods</option>
                            <?php $__currentLoopData = $findPaymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($datas->id); ?>"><?php echo e($datas->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Transaction ID<span class="text-danger">*</span></label>
                        <input type="text" name="transactionID" id="transactionID" class="form-control col-md-7" placeholder="Transaction ID">
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Received Amount ($) <span class="text-danger">*</span></label>
                        <input type="number" name="received_amount" id="received_amounts" min="0" step="0.01" class="form-control col-md-7" placeholder="Received Amount ($)" required>
                    </div>
                    

                    <div class="row form-group ">
                        <label class="col-md-5">Transaction Date <span class="text-danger">*</span></label>
                        <input type="date" name="trans_date" id="trans_date" class="form-control col-md-7" max="<?php echo e($today); ?>" placeholder="Transaction Date" required>
                    </div>
                    <div class="row form-group ">
                        <label class="col-md-5">Note</label>
                        <textarea type="text" rows="5" name="note" id="note" class="form-control col-md-7" placeholder="Note"></textarea>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="updateBudgetReceiveBtn">Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->


<script type="text/javascript">
    function getDataA(budgetRId) {
        // console.log(subMenu_id);
        $.ajax({
            url: "findBudgtRecID", // path to function
            method: "GET",
            data: {

                budgetRId: budgetRId
            },
            dataType: "JSON",

            success: function(res) {

                // console.log(res.payMethodName);
                $("#receBId").val(res.id);
                $("#transactionID").val(res.transactionID);
                $("#received_amounts").val(res.received_amount);
                // $("#charges").val(res.charge);
                // $("#total_amounts").val(res.total_amount);
                // $("#charge_notes").val(res.charge_note);
                $("#trans_date").val(res.trans_date);
                $("#note").text(res.note);

                if(res.payMethodName != null)
                {
                    $("#payMethodName").text(res.payMethodName);
                }else{
                    $("#payMethodName").text('N/A');
                }

                if(res.clientName != null)
                {
                    $("#clientName").text(res.clientName);
                }else{
                    $("#clientName").text('N/A');
                }
            },
        });
    }
</script>





<?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/accounts/administration/budgetReceived/editbudget.blade.php ENDPATH**/ ?>