<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">Pay Now</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>

        <form id="payNowForm" action="<?php echo e(url('subscriptions-pay-now')); ?>" enctype="multipart/form-data" method="post" style="padding:10px">
            <?php echo csrf_field(); ?>
            <div class="modal-body">

                <div class="form-group">

                    <div class="row form-group">
                        <label class="col-md-4">Paid To <span class="text-danger">*</span></label>
                        <input type="text" name="receiver_name" class="form-control col-md-8" placeholder="Receiver Name" required>
                    </div>

                    <div class="row form-group ">
                        <label class="col-md-4">Payment Method <span class="text-danger">*</span></label>
                        <select class="col-md-8 form-control select2bs4" name="payment_method_id" style="width: 66.667%" required>
                            <option value="" selected="" disabled>Select Payment Method</option>
                            <?php $__currentLoopData = $findPaymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payNow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($payNow->id); ?>"><?php echo e($payNow->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="row form-group">
                        <label class="col-md-4">Billing Month <span class="text-danger">*</span></label>
                        <input type="month" name="billing_month" class="form-control col-md-8" required placeholder="Billing Month">
                    </div>
                    <div class="row form-group">
                        <label class="col-md-4">Amount</label>
                        <input type="number" id="payAmount" name="amount" min="0" step="0.01" class="form-control col-md-8" placeholder="Amount">
                    </div>
                    <div class="row form-group">
                        <label class="col-md-4">Transaction ID </label>
                        <input type="text" name="transactionID" class="form-control col-md-8" placeholder="Transaction ID Number">
                    </div>
                    <div class="row form-group">
                        <label class="col-md-4">Transaction Date <span class="text-danger">*</span></label>
                        <input type="date" name="trans_date" class="form-control col-md-8" max="<?php echo e($today); ?>" required placeholder="Transaction Date">
                    </div>
                    <div class="row form-group ">
                        <label class="col-md-4">Note</label>
                        <textarea type="text" rows="5" name="note" class="form-control col-md-8" placeholder="Note"></textarea>
                    </div>
                    <input type="hidden" id="subIDs" name="subscription_id">
                    <input type="hidden" id="subscription_type_ids" name="subscription_type_id">
                </div>

                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="payNowBtn">Save</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->

<script>
    $("#payNowBtn").click(function () {
        $(this).attr("disabled", "disabled");
        $('#payNowForm').submit();
        setTimeout('$("#payNowBtn").removeAttr("disabled")', 1500);
    });
</script>

<script type="text/javascript">
    function getDataID(subsId) {
        // console.log(subsId);
        $.ajax({
            url: "findSubscriptionID", // path to function
            method: "GET",
            data: {
                subsId: subsId
            },
            dataType: "JSON",
            success: function(res) {
                // console.log(res.subscription_type_id);
                $("#subIDs").val(res.id);
                $("#payAmount").val(res.amount);
                $("#subscription_type_ids").val(res.subscription_type_id);
            },
        });
    }
</script>



<script type="text/javascript">
    $(document).ready(function () {
        $(document).on('keyup change','#payAmount',function(){
            var accountsTotal = parseFloat($('#accountsTotal').val());
            var payAmount = parseFloat($('#payAmount').val());

            if( payAmount > accountsTotal ) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'You can not Give more than Accounts Total Amount !!!',
                });

                $('#payAmount').val(0.0);
            }else{
                $('#payAmount').val(payAmount);
            }
        });
    });

</script>
<?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/accounts/administration/payTo/subscription/payNow.blade.php ENDPATH**/ ?>