<?php $__env->startSection('title'); ?>
Users List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Users List
                            <a href="#" title="" data-toggle="modal" data-target="#modal-xl">
                                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                            </a>
                            <a href="javascript:history.back()">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>

                    <!-- /.card-header -->
                    <div class="card-body">
                        <!-----------------------Active/Inactive Button--------------------->

                        <div class="btn-group " style="float: right; padding-right:10px;">
                            <button type="button" id="userBtn"
                                class="btn btn-success dropdown-toggle dropdown-icon btn-sm"
                                data-toggle="dropdown">View All
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <div class="dropdown-menu dropdown-content" role="menu"  style="padding-right:10px;">

                                <a class="dropdown-item"
                                href="javascript:void(0)" onclick="showUsers(1)"> <i class="far fa-user"
                                    style="padding-right:10px;"></i>View All</a>
                                <a class="dropdown-item"
                                    href="javascript:void(0)" onclick="showUsers(2)"> <i class="far fa-user"
                                    style="padding-right:10px; "></i>
                                    Admin</a>
                                <a class="dropdown-item"
                                    href="javascript:void(0)" onclick="showUsers(3)"> <i class="far fa-user"
                                    style="padding-right:10px; "></i>
                                    Client</a>
                                <a class="dropdown-item"
                                href="javascript:void(0)" onclick="showUsers(4)" >
                                       <i class="far fa-user"
                                        style="padding-right:10px;"></i>Vendor</a>

                                <a class="dropdown-item"
                                href="javascript:void(0)" onclick="showUsers(5)">
                                      <i class="far fa-user"
                                        style="padding-right:10px;"></i>Supervisor</a>
                                <a class="dropdown-item"
                                        href="javascript:void(0)" onclick="showUsers(6)">
                                                <i class="far fa-user"
                                                style="padding-right:10px;"></i>Employee</a>
                            </div>
                        </div>

                        <div class="btn-group " style="float: right; padding-right:10px;">
                            <button type="button" id="statusBtn"
                                class="btn btn-success dropdown-toggle dropdown-icon btn-sm"
                                data-toggle="dropdown">Active
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <div class="dropdown-menu dropdown-content" role="menu"  style="padding-right:10px;">

                                <a class="dropdown-item"
                                    onclick="showStatus(3)"><i class="fas fa-check"
                                    style="padding-right:10px;"></i>Active</a>
                                <a class="dropdown-item"
                                    onclick="showStatus(4)"><i class="fas fa-times-circle"
                                    style="padding-right:10px;"></i>InActive</a>
                            </div>
                        </div>

                        <input type="hidden" id="statusId" value="3">
                        <input type="hidden" id="UsersId" value="1">

                        <table id="example1" class="table table-bordered table-striped changeData">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Address</th>
                                    <th>Gender</th>
                                    <th>Date of Birth</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody class="tb">
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="tr">
                                    <td><?php echo e($key+1); ?></td>
                                    <td><a href="<?php echo e(url('view-employee-profile-'.$user->id)); ?>"><?php echo e($user->name); ?></a></td>
                                    
                                    <td><?php echo e($user->email); ?></td>
                                    <td><?php echo e($user->phone); ?></td>
                                    <td><?php echo e($user->address); ?></td>
                                    <td><?php echo e($user->gender); ?></td>
                                    <?php if($user->dob==null): ?> <td>N/A</td> <?php else: ?><td><?php echo e($user->dob); ?></td><?php endif; ?>
                                    <td class="project-actions text-right"><a class="btn btn-primary btn-sm"  data-toggle="modal" data-target="#modal-default" onclick="getId(<?php echo e($user->id); ?>)" ><i class="fas fa-wrench"></i> PassWord Reset</a>
                                        <a class="btn btn-info btn-sm" href="<?php echo e(url('editUserprofile-'.$user->id)); ?>"> <i class="fas fa-pencil-alt"></i> Edit </a>
                                        <a class="btn btn-danger btn-sm" href="<?php echo e(url('delete-employee-'.$user->id)); ?>" id="delete"><i class="fas fa-trash"></i>Delete</a></td> </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

<div class="modal fade" id="modal-default">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">

                        <div class="login-box col-md-12" >
                            <div class="card card-outline card-primary" style="background-color: #001f3f">
                                <div class="card-header text-center text-white">
                                    <a  class="h1"><b>Password</b>Reset</a>
                                </div>
                                <div class="card-body">
                                    <p class="login-box-msg text-white">You are only one step a way from your new password, Update your
                                        password now.</p>
                                    <form action="<?php echo e(url('users-update-password')); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" id="id" name="id">
                                        <div class="input-group mb-3">
                                            <input type="password" name="c_password" id="c_password" class="form-control" placeholder="Password">
                                            <div class="input-group-append">
                                                <div class="input-group-text">
                                                    <span class="fas fa-lock"></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="input-group mb-3">
                                            <input type="password" id="con_password" name="con_password" class="form-control" placeholder="Confirm Password">
                                            <div class="input-group-append">
                                                <div class="input-group-text">
                                                    <span class="fas fa-lock"></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <button type="submit" id="Sub" class="btn btn-primary btn-block">Change password</button>
                                            </div>
                                            <!-- /.col -->
                                        </div>
                                    </form>

                                    <p class="mt-3 mb-1">
                                        <a href="<?php echo e(url('manage-employee')); ?>"><b>Back</b></a>
                                    </p>
                                </div>
                                <!-- /.login-card-body -->
                            </div>
                        </div>
                        <!-- /.login-box -->

                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<script>
    function getId(r)
    {
       console.log(r);
       $("#id").val(r);
    }
</script>
<script>
    function showUsers(r)
    {
        if(r == 1){
            $("#userBtn").text('View All');
        }
        else if(r == 2){
            $("#userBtn").text('Admin');
        }
        else if(r == 3){
            $("#userBtn").text('Client');
        }
        else if(r == 4){
            $("#userBtn").text('Vendor');
        }
        else if(r == 5){
            $("#userBtn").text('Supervisor');
        }
        else{
            $("#userBtn").text('Employee');
        }

       $("#UsersId").val(r);

       var a_id =  $("#statusId").val();

       var id = r;

       if (id != '') {
            $.ajax({
                url: "findUsers",
                method: "GET",
                data: {
                    id: id,
                    a_id: a_id
                },
                dataType: "JSON",
                success: function (data)
                {
                       //console.log(data);
                    $('.changeData .tr').remove();

                    if(a_id == 3){
                    $.each(data, function(key, value){
                        //console.log(value.name);
                        var index = key+1;

                        $(".changeData .tb").first().before
                        (
                                '<tr class="tr">'+
                                    '<td>' + index + '</td>'+
                                    '<td><a href="view-employee-profile-'+value.id+'">'+value.name+ '</a></td>'+
                                    '<td>' +value.email+ '</td>'+
                                    '<td>' +value.phone+ '</td>'+
                                    '<td>' +value.address+ '</td>'+
                                    '<td>' +value.gender+ '</td>'+
                                    '<td>' +value.dob+ '</td>'+
                                    '<td class="project-actions text-right"><a class="btn btn-primary btn-sm"  data-toggle="modal" data-target="#modal-default" onclick="getId('+value.id+')"><i class="fas fa-wrench"></i> PassWord Reset</a> <a class="btn btn-info btn-sm" href="editUserprofile-'+value.id+'"> <i class="fas fa-pencil-alt"></i> Edit </a> <a class="btn btn-danger btn-sm" href="delete-employee-'+value.id+'" id="delete"><i class="fas fa-trash"></i>Delete</a></td> </td>'+
                                '</tr>'
                        );

                    });
                  }
                  else{
                    $.each(data, function(key, value){
                        //console.log(value.name);
                        var index = key+1;

                        $(".changeData .tb").first().before
                        (
                                '<tr class="tr">'+
                                    '<td>' + index + '</td>'+
                                    '<td>' +value.name+ '</td>'+
                                    '<td>' +value.email+ '</td>'+
                                    '<td>' +value.phone+ '</td>'+
                                    '<td>' +value.address+ '</td>'+
                                    '<td>' +value.gender+ '</td>'+
                                    '<td>' +value.dob+ '</td>'+
                                    '<td class="project-actions text-right"><a class="btn btn-primary btn-sm"  data-toggle="modal" data-target="#modal-default" onclick="getId('+value.id+')"><i class="fas fa-wrench"></i> PassWord Reset</a> <a class="btn btn-info btn-sm" href="active-user-'+value.id+'"> <i class="fas fa-check"></i> Active </a> <a class="btn btn-danger btn-sm" href="delete-employee-'+value.id+'" id="delete"><i class="fas fa-trash"></i>Delete</a></td> </td>'+
                                '</tr>'
                        );

                    });
                  }
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }

    function showStatus(r)
    {
        if(r == 3){
            $("#statusBtn").text('Active');
        }
        else if(r == 4){
            $("#statusBtn").text('Inactive');
        }

       $("#statusId").val(r);

       var id =  $("#UsersId").val();
       var a_id = r;
       console.log(a_id);
       console.log(id);

       if (id != '') {
            $.ajax({
                url: "findUsers",
                method: "GET",
                data: {
                    id: id,
                    a_id:a_id
                },
                dataType: "JSON",
                success: function (data)
                {
                    //console.log(r);
                    $('.changeData .tr').remove();

                    if(r == 3){
                    $.each(data, function(key, value){
                        //console.log(value.name);
                        var index = key+1;

                        $(".changeData .tb").first().before
                        (
                                '<tr class="tr">'+
                                    '<td>' + index + '</td>'+
                                    '<td>' +value.name+ '</td>'+
                                    '<td>' +value.email+ '</td>'+
                                    '<td>' +value.phone+ '</td>'+
                                    '<td>' +value.address+ '</td>'+
                                    '<td>' +value.gender+ '</td>'+
                                    '<td>' +value.dob+ '</td>'+
                                    '<td class="project-actions text-right"><a class="btn btn-primary btn-sm"  data-toggle="modal" data-target="#modal-default" onclick="getId('+value.id+')"><i class="fas fa-wrench"></i> PassWord Reset</a> <a class="btn btn-info btn-sm" href="editUserprofile-'+value.id+'"> <i class="fas fa-pencil-alt"></i> Edit </a> <a class="btn btn-danger btn-sm" href="delete-employee-'+value.id+'" id="delete"><i class="fas fa-trash"></i>Delete</a></td> </td>'+
                                '</tr>'
                        );

                    });
                  }
                  else{
                    $.each(data, function(key, value){
                        //console.log(value.name);
                        var index = key+1;

                        $(".changeData .tb").first().before
                        (
                                '<tr class="tr">'+
                                    '<td>' + index + '</td>'+
                                    '<td>' +value.name+ '</td>'+
                                    '<td>' +value.email+ '</td>'+
                                    '<td>' +value.phone+ '</td>'+
                                    '<td>' +value.address+ '</td>'+
                                    '<td>' +value.gender+ '</td>'+
                                    '<td>' +value.dob+ '</td>'+
                                    '<td class="project-actions text-right"><a class="btn btn-primary btn-sm"  data-toggle="modal" data-target="#modal-default" onclick="getId('+value.id+')"><i class="fas fa-wrench"></i> PassWord Reset</a> <a class="btn btn-info btn-sm" href="active-user-'+value.id+'"> <i class="fas fa-check"></i> Active </a> <a class="btn btn-danger btn-sm" href="delete-employee-'+value.id+'" id="delete"><i class="fas fa-trash"></i>Delete</a></td> </td>'+
                                '</tr>'
                        );

                    });
                  }
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }
</script>
<script>
    $('#c_password, #con_password').on('keyup', function () {
        if ($('#c_password').val() == $('#con_password').val())
        {
          $("#con_password").removeClass('form-control is-invalid').addClass('form-control is-valid');
          $("#Sub").removeAttr("disabled");

        }
        else
        {
            $("#con_password").removeClass('form-control is-valid').addClass('form-control is-invalid');
            $("#Sub").attr("disabled", true);
        }

      });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.masterBlade', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/manageUsers/allActiveUsers.blade.php ENDPATH**/ ?>