<?php
    use Illuminate\Support\Carbon;
    $currentDate = Carbon::now();
    $date = strtotime($currentDate);
    $today = date('Y-m-d', $date);
    // echo $today;  strtotime(date('Y-m-d', $currentDate));
?>
<?php
    $currentURLs = URL::current(); // current url with domain name
    $currentURL = request()->path(); // current url without domain name
    // dd($currentURL);
    $findRole = DB::table('admin_role')->where('url', $currentURL)->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>



<?php $__env->startSection('title'); ?>
    Client Request Refund List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php if(!empty($findRole->url)): ?>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-success table-responsive" style="margin-top:20px;">

                        <div class="card-header text-center">
                            <h5 class="m-0 text-white">Client Refund Request List </h5>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">

                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Order Details</th>
                                        <th>Payment Method</th>
                                        <th>Request Amount</th>
                                        <th>Request Date</th>
                                        <th>Status</th>
                                        <th>Note</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $getRefundData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $getData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$key); ?></td>
                                        <td>
                                            <span>Order ID: <?php echo e($getData->order->order_unique_id); ?></span>,
                                            <span> Service Type: <?php echo e($getData->order->service->name); ?></span>,
                                            <span> Quantity: <?php echo e($getData->quantity); ?></span>,
                                            <span> Rate: $<?php echo e($getData->rate); ?></span>,
                                            <span> Budget: $<?php echo e($getData->total_budget); ?></span>,
                                            <span> Total Work: <?php echo e($getData->total_work); ?></span>,
                                            <span> Total Cost: $<?php echo e($getData->total_cost); ?></span>
                                        </td>
                                        <td><?php echo e($getData->payMethod->name); ?></td>
                                        <td><?php echo e($getData->request_amount); ?></td>
                                        <td><?php echo e($getData->req_date); ?></td>
                                        <td>
                                            <?php if($getData->refund_status == 0): ?>
                                                <span class="badge badge-danger">Pending</span>
                                            <?php elseif($getData->refund_status == 1): ?>
                                                <span class="badge badge-success">Complete</span>
                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($getData->note); ?></td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-info">Action</button>
                                                <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                    data-toggle="dropdown">
                                                    <span class="sr-only">Toggle Dropdown</span>
                                                </button>
                                                <div class="dropdown-menu dropdown-content" role="menu" >
                                                    <?php if(Auth::user()->role == 1 || Auth::user()->role == 2): ?>
                                                        <?php if($getData->refund_status == 0): ?>
                                                            <a class="dropdown-item" href="<?php echo e(url('pay-clients-refund-request-'.$getData->id)); ?>"><span
                                                            class="fas fa-hand-holding-usd" style="padding-right:10px;"></span> Pay Now</a>
                                                        <?php else: ?>
                                                        <a class="dropdown-item" href="#"><span
                                                            class="fas fa-exclamation-circle" style="padding-right:10px;"></span> N/A</a>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

    <?php else: ?>
        <?php echo $__env->make('admin.404', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.masterBlade', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/accounts/administration/manageRefund/clientRefund.blade.php ENDPATH**/ ?>