<?php $__env->startSection('title'); ?>
    Profile
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

    <!-- Main content -->
    <section class="content" style="padding: 20px">
        <div class="container-fluid ">
            <div class="row justify-content-center">
                <div class="col-md-6" >

                    <!-- Profile Image -->
                    <div class="card card-primary card-outline">
                        <div class="card-body box-profile">
                            <div class="text-center">
                                <img class="profile-user-img img-fluid img-circle" src="<?php echo e((!empty($data->image)) ? url('upload/userImage/'.$data->image):url('upload/NoImage.png')); ?>" alt="User Avatar">

                            </div>

                            <h3 class="profile-username text-center"><b><?php echo e($data->name); ?></b></h3>

                            <p class="text-muted text-center"><?php if($data->role==1): ?>Super Admin <?php elseif($data->role==2): ?> Admin <?php endif; ?></p>

                            <ul class="list-group list-group-unbordered mb-3">
                                <li class="list-group-item">
                                    <b>Email</b> <a class="float-right"><?php echo e($data->email); ?></a>
                                </li>
                                <li class="list-group-item">
                                    <b>Phone</b> <a class="float-right"><?php echo e($data->phone); ?></a>
                                </li>
                                <li class="list-group-item">
                                    <b>Gender</b> <a class="float-right"><?php echo e($data->gender); ?></a>
                                </li>
                            </ul>


                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                    <!-- About Me Box -->
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">About Me</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">

                            <strong><i class="fas fa-map-marker-alt mr-1"></i> Location</strong>

                            <p class="text-muted"><?php echo e($data->address); ?></p>

                            <hr>

                            <strong><i class="fas fa-calendar-day"></i>  Date Of Birth</strong>

                            <p class="text-muted"><?php echo e($data->dob); ?></p>

                            <hr>

                            <hr>
                                <a href="#" title="" class="btn btn-primary btn-block" data-toggle="modal" data-target="#modal-xl">
                                    Edit Profile
                                </a>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                    <?php if(Auth::user()->role == 1 || Auth::user()->role == 2): ?>
                        <button type="button" class="btn btn-block btn-outline-primary btn-sm" data-toggle="modal" data-target="#modal-default">Update Password</button>
                    <?php endif; ?>
                </div>
                <!-- /.col -->

            </div>
            <!-- /.row -->
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->

    <div class="modal fade" id="modal-xl">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Update Employee</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col">
                            <form method="post" action="<?php echo e(url('update-profile-'.$data->id)); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>

                                <input type="hidden" name="role" value="<?php echo e($data->role); ?>">

                                <div class="row">
                                    <div class="col-12">
                                        <div class="row">
                                            <!-- 1st Row -->
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <h5>Full Name <span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <input type="text" name="name" class="form-control" required="" value="<?php echo e($data->name); ?>">
                                                    </div>
                                                </div>
                                            </div> <!-- End Col md 4 -->
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <h5>Mobile Number <span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <input type="text" name="phone" class="form-control" required="" value="<?php echo e($data->phone); ?>">
                                                    </div>
                                                </div>
                                            </div> <!-- End Col md 4 -->

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <h5>Gender <span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <select name="gender" id="gender" required="" class="form-control">
                                                            <option value="" selected="" disabled="">Select Gender
                                                            </option>
                                                            <option value="Male" <?php echo e(($data->gender == "Male" ? "selected" : "")); ?>>Male</option>
                                                            <option value="Female" <?php echo e(($data->gender == "Female" ? "selected" : "")); ?>>Female</option>
                                                            <option value="Other" <?php echo e(($data->gender == "Female" ? "selected" : "")); ?>>Other</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div> <!-- End Col md 4 -->

                                        </div> <!-- End 1stRow -->

                                        <div class="row">
                                            <!-- 3rd Row -->
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <h5>Address</h5>
                                                    <div class="controls">
                                                        <textarea type="text" name="address" class="form-control" ><?php echo e($data->address); ?></textarea>
                                                    </div>
                                                </div>
                                            </div> <!-- End Col md 4 -->
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <h5>Date of Birth </h5>
                                                    <div class="controls">
                                                        <input type="date" name="dob" class="form-control" value="<?php echo e($data->dob); ?>">
                                                    </div>
                                                </div>
                                            </div> <!-- End Col md 4 -->
                                        </div> <!-- End 3rd Row -->
                                        <div class="row">
                                            <!-- 4th Row -->


                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <h5>Profile Image</h5>
                                                    <div class="controls">
                                                        <input type="file" name="image" class="form-control" id="image" value="<?php echo e($data->image); ?>">
                                                    </div>
                                                </div>
                                            </div> <!-- End Col md 4 -->
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <div class="controls">
                                                        <img id="showImage" src="<?php echo e((!empty($data->image)) ? url('upload/userImage/'.$data->image):url('upload/NoImage.png')); ?>"
                                                            style="width: 100px; height: 110px; border: 1px solid #000000;">
                                                    </div>
                                                </div>
                                            </div> <!-- End Col md 4 -->

                                        </div> <!-- End 4th Row -->

                                        <div class="row">
                                            <!-- 6TH Row -->

                                        </div> <!-- End 6TH Row -->
                                        <div class="row" style="margin-top: 20px">
                                            <!-- 7TH Row -->
                                            <div class="col-md-5">
                                                <div class="text-xs-right">
                                                    <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                            </div>
                                        </div> <!-- End 7TH Row -->
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- /.col -->
                    </div>
                    <!-- /.row -->
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->

    <div class="modal fade" id="modal-default">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">

                            <div class="login-box col-md-12" >
                                <div class="card card-outline card-primary" style="background-color: #001f3f">
                                    <div class="card-header text-center text-white">
                                        <a  class="h1"><b>Password</b>Reset</a>
                                    </div>
                                    <div class="card-body">
                                        <p class="login-box-msg text-white">You are only one step a way from your new password, Update your
                                            password now.</p>
                                        <form action="<?php echo e(url('update-password-'.$data->id)); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <div class="input-group mb-3">
                                                <input type="password" name="password" id="password" class="form-control" placeholder="Password">
                                                <div class="input-group-append">
                                                    <div class="input-group-text">
                                                        <span class="fas fa-lock"></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="input-group mb-3">
                                                <input type="password" id="cpassword" name="Cpassword" class="form-control" placeholder="Confirm Password">
                                                <div class="input-group-append">
                                                    <div class="input-group-text">
                                                        <span class="fas fa-lock"></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <button type="submit" id="Submit" class="btn btn-primary btn-block">Change password</button>
                                                </div>
                                                <!-- /.col -->
                                            </div>
                                        </form>

                                        
                                    </div>
                                    <!-- /.login-card-body -->
                                </div>
                            </div>
                            <!-- /.login-box -->

                    </div>
                    <!-- /.row -->
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->

    <!------------------------- /.view Image ------------------------------>
<script type="text/javascript">
    $(document).ready(function () {
        $('#image').change(function (e) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('#showImage').attr('src', e.target.result);
            }
            reader.readAsDataURL(e.target.files['0']);
        });
    });
</script>

<!-------------------------/.password Check------------------------------>
<script>
    $('#password, #cpassword').on('keyup', function () {
        if ($('#password').val() == $('#cpassword').val())
        {
          $("#cpassword").removeClass('form-control is-invalid').addClass('form-control is-valid');
          $("#Submit").removeAttr("disabled");

        }
        else
        {
            $("#cpassword").removeClass('form-control is-valid').addClass('form-control is-invalid');
            $("#Submit").attr("disabled", true);
        }


      });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.masterBlade', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/profile/viewProfile.blade.php ENDPATH**/ ?>