<?php
    use Illuminate\Support\Carbon;
    $currentDate = Carbon::now();
    $date = strtotime($currentDate);
    $today = date('Y-m-d', $date);
    // echo $today;  strtotime(date('Y-m-d', $currentDate));
?>
<?php
    $currentURLs = URL::current(); // current url with domain name
    $currentURL = request()->path(); // current url without domain name
    // dd($currentURL);
    $findRole = DB::table('admin_role')->where('url', $currentURL)->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>



<?php $__env->startSection('title'); ?>
Budget Received
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php if($findRole->url == $currentURL ): ?>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Budget Received List
                            <a href="#" title="" data-toggle="modal" data-target="#adds-budget">
                                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                            </a>
                            <a href="<?php echo e(url('view-system-config')); ?>">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Operator</th>
                                    <th>Clients Name</th>
                                    <th>Payment Method</th>
                                    <th>Received Amount</th>
                                    <th>Transaction Date</th>
                                    <th>System Date</th>
                                    <th>Note</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $getBudgetReceived; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$budget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key+1); ?></td>
                                    <td>
                                        <?php if($budget->created_by != null): ?>
                                        <?php echo e($budget->operator->name); ?>

                                        <?php else: ?>
                                        N/A
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($budget->client_id != null): ?>
                                        <?php echo e($budget->clients->name); ?>

                                        <?php else: ?>
                                        N/A
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($budget->payment_method_id != null): ?>
                                        <?php echo e($budget->payMethod->name); ?>

                                        <?php else: ?>
                                        N/A
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($budget->received_amount); ?></td>
                                    <td><?php echo e($budget->trans_date); ?></td>
                                    <td><?php echo e($budget->created_at); ?></td>
                                    <td><?php echo e($budget->note); ?></td>
                                    <td>
                                        <?php if($budget->status == 3): ?><span
                                            class="textSize badge badge-warning">Pending</span>
                                        <?php elseif($budget->status == 4): ?><span
                                            class="textSize badge badge-warning">Declined</span>
                                        <?php else: ?><span class="textSize badge badge-info">Accept</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">
                                                <?php if(Auth::user()->role == 1 || Auth::user()->role == 2): ?>
                                                <a class="dropdown-item" data-toggle="modal" data-target="#edit-budget"
                                                    onclick="getDataA('<?php echo $budget->id ?>')" href="#"><span
                                                        class="fa fa-edit" style="padding-right:10px;"></span> Edit</a>

                                                <?php if($budget->status == 3 ): ?>
                                                <a class="dropdown-item text-success" id="accept"
                                                    href="<?php echo e(url('client-budget-received-accept-'.$budget->id)); ?>"><span
                                                        class="fa fa-check" style="padding-right:10px;"></span>
                                                    Accept</a>
                                                <a class="dropdown-item text-danger" id="declined"
                                                    href="<?php echo e(url('client-budget-received-declined-'.$budget->id)); ?>"><span
                                                        class="fas fa-times" style="padding-right:10px;"></span>
                                                    Declined</a>
                                                <?php endif; ?>
                                                
                                                <?php endif; ?>
                                                <?php if(Auth::user()->role == 1): ?>
                                                <a class="dropdown-item" id="delete"
                                                    href="<?php echo e(url('destroy-budget-received-'.$budget->id)); ?>"><span
                                                        class="fa fa-trash" style="padding-right:10px;"></span>
                                                    Delete</a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

<!-- /Add budget Modal Start -->
<div class="modal fade" id="adds-budget">
    <?php echo $__env->make('admin.page.accounts.administration.budgetReceived.addbudget', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<!-- /Add budget Modal End -->

<!-- /Edit budget Modal Start -->
<div class="modal fade" id="edit-budget">
    <?php echo $__env->make('admin.page.accounts.administration.budgetReceived.editbudget', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<!-- /Edit budget Modal End -->

<?php else: ?>
<?php echo $__env->make('admin.404', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>
<script>
    $("#createBudgetReceiveBtn").click(function () {
        $(this).attr("disabled", "disabled");
        $('#createBudgetReceiveForm').submit();
        setTimeout('$("#createBudgetReceiveBtn").removeAttr("disabled")', 1500);
    });
    $("#updateBudgetReceiveBtn").click(function () {
        $(this).attr("disabled", "disabled");
        $('#updateBudgetReceiveForm').submit();
        setTimeout('$("#updateBudgetReceiveBtn").removeAttr("disabled")', 1500);
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.masterBlade', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/admin/page/accounts/administration/budgetReceived/budgetReceived.blade.php ENDPATH**/ ?>