<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>CMS Login</title>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="<?php echo e(asset('admin_assets/plugins/fontawesome-free/css/all.min.css')); ?>">
    <!-- icheck bootstrap -->
    <link rel="stylesheet" href="<?php echo e(asset('admin_assets/plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('admin_assets/dist/css/adminlte.min.css')); ?>">

    <style>
    @import url('https://fonts.googleapis.com/css?family=Raleway:400,700');

    * {
        box-sizing: border-box;
        margin: 0;
        padding: 0;
        font-family: Raleway, sans-serif;
    }

    body {
        background: linear-gradient(90deg, #a4e3ed, #1295ab);
    }

    .container {
        display: flex;
        align-items: center;
        justify-content: center;
        /* min-height: 70vh; */
        padding-top: 7%;
        padding-bottom: 12%;
    }

    .screen {
        background: linear-gradient(90deg, #1939ad, #5176dd);
        position: relative;
        height: 600px;
        width: 420px;
        box-shadow: 0px 0px 24px #5C5696;
    }

    .screen__content {
        z-index: 1;
        position: relative;
        height: 100%;
    }

    .screen__background {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: 0;
        -webkit-clip-path: inset(0 0 0 0);
        clip-path: inset(0 0 0 0);
    }

    .screen__background__shape {
        transform: rotate(45deg);
        position: absolute;
    }

    .screen__background__shape1 {
        height: 520px;
        width: 520px;
        background: #FFF;
        top: -50px;
        right: 120px;
        border-radius: 0 72px 0 0;
    }

    .screen__background__shape2 {
        height: 220px;
        width: 220px;
        background: #143799;
        top: -172px;
        right: 0;
        border-radius: 32px;
    }

    .screen__background__shape3 {
        height: 540px;
        width: 190px;
        background: #143799;
        top: -24px;
        right: 0;
        border-radius: 32px;
    }

    .screen__background__shape4 {
        height: 400px;
        width: 200px;
        background: #143799;
        top: 420px;
        right: 50px;
        border-radius: 60px;
    }

    .login {
        width: 320px;
        padding: 30px;
        /* padding-top: 156px; */
    }

    .login__field {
        padding: 20px 0px;
        position: relative;
    }

    .login__icon {
        position: absolute;
        top: 30px;
        color: #7875B5;
    }

    .login__input {
        border: none;
        border-bottom: 2px solid #D1D1D4;
        background: none;
        padding: 10px;
        padding-left: 24px;
        font-weight: 700;
        width: 100%;
        transition: .2s;
    }

    .login__input:active,
    .login__input:focus,
    .login__input:hover {
        outline: none;
        border-bottom-color: #6A679E;
    }

    .login__submit {
        background: #fff;
        font-size: 14px;
        margin-top: 30px;
        padding: 16px 20px;
        border-radius: 26px;
        border: 1px solid #D4D3E8;
        text-transform: uppercase;
        font-weight: 700;
        display: flex;
        align-items: center;
        width: 100%;
        color: #4C489D;
        box-shadow: 0px 2px 2px #5C5696;
        cursor: pointer;
        transition: .2s;
    }

    .login__submit:active,
    .login__submit:focus,
    .login__submit:hover {
        border-color: #6A679E;
        outline: none;
    }

    .button__icon {
        font-size: 24px;
        margin-left: auto;
        color: #7875B5;
    }

    .social-login {
        position: absolute;
        height: 140px;
        width: 165px;
        text-align: center;
        bottom: 0px;
        right: 0px;
        color: #fff;
        bottom: -30px;
    }

    .social-icons {
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .social-login__icon {
        color: #fff;
        font-size: 22px;
        padding: 20px 10px;
        text-decoration: none;
        /* text-shadow: 0px 0px 8px #7875B5; */
    }

    .social-login__icon:hover {
        color: #ffffff;
        transform: scale(1.5);
    }

    footer {
        background: #0d2089;
        margin-bottom: 0px;
        text-align: center;
        padding: 20px;
        align-items: center;
        display: flex;
        justify-content: center;
        justify-items: center;
    }

    footer p {
        color: white;
        font-size: 20px;
        margin-bottom: 0;
    }

    footer p a {
        color: #2acae5;
    }

    .loginLogo {
        text-align: center;
        padding-top: 20px;
    }

    .loginLogo img {
        width: 25%;

    }
    </style>

</head>

<?php
$findLoginLogo = App\Models\Company::first();
?>

<body class="hold-transition">

    <div class="container">
        <div class="screen">
            <div class="screen__content">

                <div class="loginLogo">
                    <img src="<?php echo e($findLoginLogo->login_logo ? asset($findLoginLogo->login_logo) : asset('logo.png')); ?>"
                        alt="Login Logo">
                </div>

                <form method="POST" action="<?php echo e(route('login')); ?>" class="login">
                    <?php echo csrf_field(); ?>
                    <div class="login__field">
                        <i class="login__icon fas fa-user"></i>
                        <input type="email" class="login__input" id="email" name="email" :value="old('email')" autofocus
                            required placeholder="User Email">
                    </div>
                    <div class="login__field">
                        <i class="login__icon fas fa-lock"></i>
                        <input type="password" id="password" class="login__input" name="password" required
                            autocomplete="current-password" placeholder="Password">
                    </div>

                    <button type="submit" class="button login__submit">
                        <span class="button__text">Log In Now</span>
                        <i class="button__icon fas fa-chevron-right"></i>
                    </button>
                </form>

                <div class="social-login">
                    <h3>Contact Us</h3>
                    <div class="social-icons">
                        <a href="https://www.facebook.com/proreviewapp/" target="_blank"
                            class="social-login__icon fab fa-facebook"></a>
                        <a href="https://www.linkedin.com/company/proreviewapp" target="_blank"
                            class="social-login__icon fab fa-linkedin"></a>
                        <a href="https://join.skype.com/invite/bPGfdNe4dhX3" target="_blank"
                            class="social-login__icon fab fa-skype"></a>
                        <a href="https://www.proreviewapps.com/" target="_blank"
                            class="social-login__icon fas fa-globe"></a>
                    </div>
                </div>
            </div>
            <div class="screen__background">
                <span class="screen__background__shape screen__background__shape4"></span>
                <span class="screen__background__shape screen__background__shape3"></span>
                <span class="screen__background__shape screen__background__shape2"></span>
                <span class="screen__background__shape screen__background__shape1"></span>
            </div>
        </div>
    </div>




    <footer style="background: #143799; bottom:0px">
        <p>
            Developed by
            <a target="_blank" href="https://lutfurhasan.com/">Lutfur Hasan</a>
            Version - 2.0
        </p>
    </footer>

    <!-- jQuery -->
    <!-- <script src="<?php echo e(asset('admin_assets/plugins/jquery/jquery.min.js')); ?>"></script> -->
    <!-- Bootstrap 4 -->
    <!-- <script src="<?php echo e(asset('admin_assets/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script> -->
    <!-- AdminLTE App -->
    <!-- <script src="<?php echo e(asset('admin_assets/dist/js/adminlte.min.js')); ?>"></script> -->


    <script>
    </script>

</body>

</html><?php /**PATH /home/lutfwfad/trial.proreviewapps.com/resources/views/auth/login.blade.php ENDPATH**/ ?>