<?php
    $findRole = DB::table('admin_role')->where('url', 'view-hold-order-e')->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>

@extends('admin.masterBlade')

@section('title')
Hold Order List
@endsection

@section('content')

    @if($findRole != null )

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card card-success table-responsive" style="margin-top:20px;">

                            <div class="card-header text-center">
                                <h5 class="m-0 text-white">Hold Order List
                                </h5>
                            </div>

                            <!-- /.card-header -->
                            <div class="card-body">
                                <!-----------------------Active/Inactive Button--------------------->
                                <table id="example1" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>SN</th>
                                            <th>Assign Uni_Id</th>
                                            <th>Total Quantity</th>
                                            <th>Rate</th>
                                            <th>Budget</th>
                                            <th>Service</th>
                                            <th>Targeted Date</th>
                                            <th>App Link</th>
                                            <th>Platfrom</th>
                                            <th>GEO</th>
                                            <th>Per Day</th>
                                            <th>KeyWord</th>
                                            <th>Comment</th>
                                            <th>Status</th>
                                            <th>File</th>
                                            <th>Progress</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($datas as $key=>$data)
                                        @php
                                           $flag = 1;
                                        @endphp
                                        <tr>
                                            <td>{{$key+1}}</td>
                                            <td><a href="{{url('work-details-'.$data->id)}}" target="_blank" >{{$data->unique_id}}</a></td>
                                            <td>{{$data->total_quantity}}</td>
                                            <td>{{number_format($data->vendor_rate, 2)}}</td>
                                            <td>{{number_format($data->total_service_cost, 2)}}</td>
                                            <td>{{$data->name}}</td>
                                            <td>{{$data->target_date}}</td>
                                            <td><a href="{{$data->apps_link}}" target="_blank" >Click Here</a></td>
                                            <td>{{$data->platform}}</td>
                                            <td>{{$data->geo}}</td>
                                            <td>{{$data->perday}}</td>
                                            <td>{{$data->key_word}}</td>
                                            <td>{{$data->comment}}</td>
                                            <td>
                                                @if($data->work_status ==1)<span class="textSize badge badge-warning">Pending</span>
                                                @elseif($data->work_status ==2)<span class="textSize badge badge-info">Accept</span>
                                                @elseif($data->work_status ==3)<span class="textSize badge badge-success">In Process</span>
                                                @elseif($data->work_status ==4)<span class="textSize badge badge-warning ">Finished</span>
                                                @elseif($data->work_status ==5)<span class="textSize badge badge-danger">Refilling</span>
                                                @elseif($data->work_status ==6)<span class="textSize badge badge-secondary">Refiled</span>
                                                @elseif($data->work_status ==7)<span class="textSize badge badge-warning">Hold</span>
                                                @elseif($data->work_status ==8)<span class="textSize badge badge-danger">Reject</span>
                                                @elseif($data->work_status ==9)<span class="textSize badge badge-primary">Update</span>
                                                @else<span class="badge">N/A</span>
                                                @endif

                                            </td>
                                            <td>@if($data->file != null)<a href="{{asset('upload/orderFile/'.$data->file)}}" download>{{$data->file}}</a>@else No File @endif</td>
                                            <td>
                                                @foreach ($dataCount as $dc)
                                                    @if($dc->id == $data->id)

                                                        {{$dc->total}}/{{$data->total_quantity}}
                                                        @php
                                                          $flag = 0;
                                                        @endphp
                                                    @endif
                                                @endforeach

                                                @if( $flag == 1)
                                                    0/{{$data->total_quantity}}
                                                @endif
                                            </td>

                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
            </div>
        </section>

    @else
        @include('admin.404')
    @endif

@endsection
