
@extends('admin.masterBlade')

@section('title')
Canceled Order List
@endsection

@section('content')

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Canceled Order List
                            <a href="javascript:history.back()">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>

                    <!-- /.card-header -->
                    <div class="card-body">
                        <!-----------------------Active/Inactive Button--------------------->

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Unique Id</th>
                                    <th>Client Name</th>
                                    <th>App Link</th>
                                    <th>Platfrom</th>
                                    <th>GEO</th>
                                    <th>Service Type</th>
                                    <th>Last Date</th>
                                    <th>Quantity</th>
                                    <th>Service Cost</th>
                                    <th>Budget</th>
                                    <th>Perday Work</th>
                                    <th>KeyWord</th>
                                    <th>Comment</th>
                                    <th>File</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach($datas as $key=>$data)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td><a href="{{url('check-work-onOrderC-'.$data->id)}}" target="_blank" >{{$data->order_unique_id}}</a></td>
                                    <td>{{$data->client->name}}</td>
                                    <td><a href="{{$data->apps_link }}" target="_blank" >Link</a></td>
                                    <td>{{$data->platform}}</td>
                                    <td>{{$data->geo}}</td>
                                    <td>{{$data->service->name}}</td>
                                    <td>{{$data->target_date}}</td>
                                    <td>{{$data->total_quantity}}</td>
                                    <td>{{$data->service_cost}}</td>
                                    <td>{{$data->total_budget}}</td>
                                    <td>{{$data->perday}}</td>
                                    <td>{{$data->key_word}}</td>

                                    <td>
                                        <input id="exp{{$key+1}}" class="exp"  type="checkbox">
                                        <div class="text">
                                            <label class="btns" for="exp{{$key+1}}"></label>
                                            {{$data->comment}}
                                        </div>
                                    </td>

                                    <td>@if($data->file != null)<a href="{{asset('upload/orderFile/'.$data->file)}}" download>{{$data->file}}</a>@else No File @endif</td>
                                    
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

@endsection

