<div class="row">
    <div class="col-md-12">
        <div class="card card-success table-responsive" style="margin-top:20px;">

            <!-- /.card-header -->
            <div class="card-body">
                <!-----------------------Active/Inactive Button--------------------->
                <table id="searchDatatable1" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th width="1%">SN</th>
                            <th width="5%">Unique Id</th>
                            <th width="5%">App Link</th>
                            <th width="5%">Platfrom</th>
                            <th width="5%">GEO</th>
                            <th width="5%">Service Type</th>
                            <th width="5%">Last Date</th>
                            <th width="5%">Quantity</th>
                            <th width="5%">Service Cost</th>
                            <th width="5%">Budget</th>
                            <th width="5%">Perday Work</th>
                            <th width="5%">KeyWord</th>
                            <th width="10%">Status</th>
                            <th width="23%">Comment</th>
                            <th width="1%">File</th>
                            <th width="10%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($datas as $key=>$data)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td><a href="{{url('check-work-onOrderC-'.$data->id)}}"
                                    target="_blank">{{$data->order_unique_id}}</a></td>
                            <td><a href="{{$data->apps_link }}" target="_blank">Link</a></td>
                            <td>{{$data->platform}}</td>
                            <td>{{$data->geo}}</td>
                            <td>{{$data->service->name}}</td>
                            <td>{{$data->target_date}}</td>
                            <td>{{$data->total_quantity}}</td>
                            <td>{{$data->service_cost}}</td>
                            <td>{{$data->total_budget}}</td>
                            <td>{{$data->perday}}</td>
                            <td>{{$data->key_word}}</td>
                            <td>

                                @if($data->order_status ==1)<span class="textSize badge badge-warning">Pending</span>
                                @elseif($data->order_status ==2)<span class="textSize badge badge-info">Accept</span>
                                @elseif($data->order_status ==3)<span class="textSize badge badge-success">In
                                    Work</span>
                                @elseif($data->order_status ==4)<span class="textSize badge badge-warning ">Finished
                                    From Admin</span>
                                @elseif($data->order_status ==5)<span
                                    class="textSize badge badge-danger">Refilling</span>
                                @elseif($data->order_status ==6)<span
                                    class="textSize badge badge-secondary">Refiled</span>
                                @elseif($data->order_status ==7)<span class="textSize badge badge-primary">Hold</span>
                                @elseif($data->order_status ==8)<span class="textSize badge badge-danger">Decline</span>
                                @elseif($data->order_status ==9)<span
                                    class="textSize badge badge-secondary">Active</span>
                                @elseif($data->order_status ==10)<span
                                    class="textSize badge badge-secondary">Completed</span>
                                @elseif($data->order_status ==11)<span
                                    class="textSize badge badge-danger">Canceled</span>
                                @else<span class="badge">N/A</span>
                                @endif

                            </td>
                            <td>
                                <input id="exp{{$key+1}}" class="exp" type="checkbox">
                                <div class="text">
                                    <label class="btns" for="exp{{$key+1}}"></label>
                                    {{$data->comment}}
                                </div>
                            </td>
                            <td>@if($data->file != null)<a href="{{asset('upload/orderFile/'.$data->file)}}"
                                    download>{{$data->file}}</a>@else No File @endif</td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-info">Action</button>
                                    <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                        data-toggle="dropdown">
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <div class="dropdown-menu dropdown-content" role="menu">
                                        @if((Auth::user()->role == 1 || Auth::user()->role == 3) &&
                                        ($data->order_status==1 ||$data->order_status==2) )
                                        <a class="dropdown-item" data-toggle="modal" data-target="#modal-default"
                                            onclick="editOrder({{$data->id}})"><i class="fas fa-check"
                                                style="padding-right:10px;"></i> Edit</a>
                                        <a class="dropdown-item" href="{{url('delete-order-'.$data->id)}}"><i
                                                class="fas fa-times-circle" style="padding-right:10px; "></i> Delete</a>
                                        @else
                                        <a class="dropdown-item">No Action</a>
                                        @endif
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
</div>

<div class="modal fade" id="modal-default">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Edit Order</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('update-client-order')}}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="order_id" id="id">
                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>App Link <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="apps_link" id="apps_link1"
                                                        class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Platform <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="platform" id="platform1" required=""
                                                        class="form-control">
                                                        <option value="" selected="" disabled="">Select Platfrom
                                                        </option>
                                                        <option value="Android">Android</option>
                                                        <option value="IOS">IOS</option>
                                                        <option value="Google">Google</option>
                                                        <option value="Others">Others</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Service Type <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="service_type_id" id="service_type_id1" required=""
                                                        class="form-control">
                                                        <option value="" selected="" disabled="">Select Service Type
                                                        </option>
                                                        @foreach ($service as $item)
                                                        <option value="{{$item->id}}">{{$item->name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 1stRow -->

                                    <div class="row" id="calculation1">
                                        <!-- 2nd Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Quantity <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" name="total_quantity" id="total_quantity1"
                                                        class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Service Cost(Per Work) <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" step="0.0001" name="service_cost"
                                                        id="service_cost1" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Budget <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" name="total_budget" id="total_budget1"
                                                        class="form-control" readonly required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 2nd Row -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Per Day Work <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" name="perday" id="perday1" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>KeyWord</h5>
                                                <div class="controls">
                                                    <input type="text" name="key_word" id="key_word1"
                                                        class="form-control">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>GEO <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="geo" id="geo1" class="form-control"
                                                        required="">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Start Date</h5>
                                                <div class="controls">
                                                    <input type="date" name="start_date" required
                                                        class="form-control min_today" id="start_date">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Delivery Date</h5>
                                                <div class="controls">
                                                    <input type="date" name="target_date" id="target_date1" required
                                                        class="form-control">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Document</h5>
                                                <div class="controls">
                                                    <input type="file" name="file" id="file1" class="form-control"
                                                        id="image">

                                                    <div class="row" id="extra">
                                                        <div class="col-md-10">
                                                            <input type="text" id="file12" class="form-control">
                                                        </div>
                                                        <div class="col-md-2">
                                                            <a href="javascript:void(0)" onclick="deleteFile()"
                                                                class="btn btn-danger"><i class="fas fa-trash"></i></a>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Comment</h5>
                                                <div class="controls">
                                                    <textarea type="text" name="comment" id="comment1"
                                                        class="form-control" id="image"></textarea>
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="row" style="margin-top: 20px">
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5"
                                                    value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<script>
function editOrder(r) {
    console.log(r);
    $("#id").val(r);
    var id = r;

    if (id != '') {
        $.ajax({
            url: "editOrder",
            method: "GET",
            data: {
                id: id,
            },
            dataType: "JSON",
            success: function(data) {
                console.log(data);
                $("#apps_link1").val(data.apps_link);
                $("#platform1").val(data.platform);
                $("#service_type_id1").val(data.service_type_id);
                $("#service_cost1").val(data.service_cost);
                $("#total_budget1").val(data.total_budget);
                $("#perday1").val(data.perday);
                $("#key_word1").val(data.key_word);
                $("#geo1").val(data.geo);
                $("#total_quantity1").val(data.total_quantity);
                $("#comment1").val(data.comment);
                $("#start_date").val(data.start_date);
                $("#target_date1").val(data.target_date);
                if (data.file == null) {
                    var div = document.getElementById('extra');
                    div.style.display = 'none';
                } else {
                    $("#file12").val(data.file);
                }

                $("#total_quantity1").attr({
                    "min": 1
                });
            }
        })
    } else {
        alert("Something is wrong ..!!");
    }
}
</script>
<script type="text/javascript">
$("#calculation1").on("keyup click", function() {
    var qty = parseFloat($('#total_quantity1').val());
    var price = parseFloat($('#service_cost1').val());

    var unit_total = parseFloat(qty * price);

    $("#total_budget1").val(unit_total.toFixed(2));
});
</script>

<script>
function deleteFile() {
    var id = $("#id").val();
    console.log(id);

    if (id != '') {
        $.ajax({
            url: "deleteFileFromOrder",
            method: "GET",
            data: {
                id: id,
            },
            dataType: "JSON",
            success: function(data) {
                console.log(data);
                var div = document.getElementById('extra');
                if (div.style.display !== 'none') {
                    div.style.display = 'none';
                } else {
                    div.style.display = 'block';
                }
            }
        })
    } else {
        alert("Something is wrong ..!!");
    }
}
</script>