@extends('admin.masterBlade')

@section('title')
Work
@endsection
@section('content')

<section class="content">
    <div class="container-fluid">

        <div class="row" style="margin-top:10px;">

            <div class="col-md-12">
                <div class="card bg-gradient-success">
                    <div class="card-header border-0 ui-sortable-handle" style="cursor: move;">

                        <h3 class="card-title">
                            Order Details
                        </h3>
                        <!-- tools card -->
                        <div class="card-tools">
                            <button type="button" class="btn btn-success btn-sm" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                        <!-- /. tools -->
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body pt-0" style="display: block;">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="card">
                                    <div class="card-header">
                                        <h2 class="card-title text-dark">Order ID : <b>{{$Orders->order_unique_id}}</b>
                                        </h2>
                                        <input type="hidden" name="order_id" id="order_id" value="{{$Orders->id}}">
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body">
                                        <div class="row">
                                            <h2 class="card-title text-dark">App Link: </h2>
                                            <!-- /.col -->
                                            <div class="col-md-5">
                                                <a href="{{$Orders->apps_link}}" target="_blank">Click Me</a>
                                            </div>
                                            <!-- /.col -->
                                            <h2 class="card-title text-dark">File: </h2>
                                            <!-- /.col -->
                                            <div class="col-md-5">
                                                <a href="{{asset('upload/orderFile/'.$Orders->file)}}" download>Download
                                                    Me</a>
                                            </div>
                                            <!-- /.col -->
                                        </div>
                                        <!-- /.row -->
                                    </div>
                                    <!-- /.card-body -->
                                    <div class="card-footer bg-light p-0" style="border-radius: 0.35rem;">
                                        <div class="row pb-3">
                                            <div class="col-md-6">
                                                <ul class="nav nav-pills flex-column">
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Order Date
                                                            <span class="float-right ">
                                                                <b>{{$Orders->created_date}}</b></span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Dalivary Date
                                                            <span class="float-right text-danger">
                                                                <b>{{$Orders->target_date}}</b></span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Speed Per day
                                                            <span class="float-right">
                                                                <b>{{$Orders->perday}}</b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            KeyWord
                                                            <span class="float-right">
                                                                <b> {{$Orders->key_word}} </b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-md-6">
                                                <ul class="nav nav-pills flex-column">
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Service Type
                                                            <span class="float-right">
                                                                <b>{{$Orders->service->name}}</b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Platfrom
                                                            <span class="float-right">
                                                                <b>{{$Orders->platform}}</b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            GEO
                                                            <span class="float-right">
                                                                <b>{{$Orders->geo}}</b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Start Point
                                                            <span class="float-right">
                                                                <b>{{ isset($first_assign_order->start_point) ? $first_assign_order->start_point : 'N/A'}}</b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>

                                        </div>
                                    </div>
                                    <!-- /.footer -->
                                </div>
                                <!-- /.card -->
                            </div>

                            <div class="col-md-4">
                                <div class="card">
                                    <div class="card-header">
                                        <h2 class="card-title text-dark">Order Status</h2>
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body">
                                        <div class="row" id="changeStatus">

                                            <h2 class="card-title text-dark">Status: </h2>
                                            <div class="col-md-10">
                                                <div class="form-group">

                                                    @if ($Orders->order_status == 7)
                                                    <select id="inputStatus" onchange="assignStatus(this)"
                                                        class="form-control custom-select">
                                                        <option value="7" disabled
                                                            {{($Orders->order_status == 7)?'selected':''}}>Hold
                                                        </option>
                                                        <option value="1">Resume</option>
                                                    @else
                                                    <select id="inputStatus" onchange="assignStatus(this)"
                                                        class="form-control custom-select"
                                                        {{ $Orders->order_status == 10 || $Orders->order_status == 11 ? 'disabled' : '' }}
                                                    >
                                                            <option value="1" disabled
                                                                {{($Orders->order_status == 1)?'selected':''}}>Pending
                                                            </option>
                                                            <option value="9" disabled
                                                                {{($Orders->order_status == 9)?'selected':''}}>Active
                                                            </option>
                                                            <option value="3" disabled title="You Can't Select This"
                                                                {{($Orders->order_status ==3)?'selected':''}}>Work
                                                                in Progress</option>
                                                            <option value="7"
                                                                {{($Orders->order_status == 7)?'selected':''}}>Hold
                                                            </option>

                                                            <option value="5" disabled
                                                                {{($Orders->order_status ==5)?'selected':''}}>
                                                                Refilling
                                                            </option>

                                                            <option disabled value="6" title="You Can't Select This"
                                                                disabled {{($Orders->order_status ==6)?'selected':''}}>
                                                                Refilled</option>
                                                            <option value="4" title="You Can't Select This" disabled
                                                                {{($Orders->order_status ==4)?'selected':''}}>
                                                                Finished From Admin</option>
                                                            <option value="10"
                                                                {{($Orders->order_status ==10)?'selected':''}}>
                                                                Completed</option>
                                                            <option value="2"
                                                                {{($Orders->order_status ==2)?'selected':''}}>
                                                                Accept</option>

                                                            <option value="11"
                                                                {{($Orders->order_status ==11)?'selected':''}}>
                                                                Canceled</option>
                                                            @endif

                                                        </select>
                                                </div>
                                            </div>
                                            <!-- /.col -->
                                        </div>
                                        <!-- /.row -->
                                    </div>
                                    <!-- /.card-body -->
                                    @php
                                        $pStatus = ($total*100)/$Orders->total_quantity;

                                        $getTotal = App\Models\WorksDetails::whereIn('status',[1,2,3])->where('order_id',$Orders->id)->where('posting_status',1)->count();
                                        $postingStatus = ($getTotal > 0) ? ($getTotal/$Orders->total_quantity)*100 : 0;
                                    @endphp
                                    <div class="card-footer bg-light pb-3" style="border-radius: 0.35rem; margin-top: -28px;">
                                        <div class="col-md-12">
                                            <ul class="nav nav-pills flex-column">
                                                <li class="nav-item">
                                                    <a class="nav-link">Progress :
                                                        <td class="project_progress">
                                                            <div class="progress progress-sm">
                                                                <div class="progress-bar bg-green" role="progressbar"
                                                                    aria-valuenow="{{$pStatus}}" aria-valuemin="0"
                                                                    aria-valuemax="100" style="width: {{$pStatus}}%">
                                                                </div>
                                                            </div>
                                                            <small>
                                                                {{number_format($pStatus)}}% Completed
                                                            </small>
                                                        </td>
                                                        <h6 class="float-right">
                                                            {{$total}}/{{$Orders->total_quantity}}
                                                        </h6>
                                                    </a>

                                                    @if($Orders->service_type_id == 1 || $Orders->service_type_id == 2)
                                                    <a class="nav-link"> Posting Status Progress :
                                                        <td class="project_progress">
                                                            <div class="progress progress-sm">
                                                                <div class="progress-bar bg-green" role="progressbar"
                                                                    aria-valuenow="{{$postingStatus}}" aria-valuemin="0"
                                                                    aria-valuemax="100" style="width: {{$postingStatus}}%">
                                                                </div>
                                                            </div>
                                                            <small>
                                                                {{number_format($postingStatus)}}% Complete
                                                            </small>
                                                        </td>
                                                        <h6 class="float-right">
                                                            {{$getTotal}}/{{$Orders->total_quantity}}
                                                        </h6>
                                                    </a>
                                                    @endif
                                                </li>
                                            </ul>

                                        </div>
                                    </div>
                                    <!-- /.footer -->
                                </div>
                                <!-- /.card -->
                            </div>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>

            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:10px;">
                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Works Details List
                            <a href="{{route('inProgress-order-v')}}">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>

                    <!-- /.card-header -->
                    <div class="card-body">
                        @if( $Orders->service_type_id !=3)
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Work U_Id</th>
                                    <th width="25%">Review Text</th>
                                    <th>Title</th>
                                    <th>User Name</th>
                                    <th>Ratting</th>
                                    <th>Posting Status</th>
                                    <th>Live Date</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($datas as $key=>$data)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td><a href="#">{{$data->work_details_u_id}}</a></td>
                                    <td>{{$data->reiew_discription}}</td>
                                    <td>{{$data->title}}</td>
                                    <td>@if($data->user_name != null){{$data->user_name}}@else N/A @endif</td>
                                    <td>
                                        @for ($i=0;$i<$data->ratting;$i++)
                                            <i class="fa fa-star text-warning"></i>
                                        @endfor
                                        @for ($i=0;$i<5-$data->ratting;$i++)
                                            <i class="far fa-star text-gray"></i>
                                        @endfor
                                         <p hidden>{{$data->ratting}}</p>
                                    </td>

                                     <!-- Posting Status  -->
                                     <td>
                                        <div id="{{'viewPostingStatus'.$data->id}}"
                                            ondblclick="getOpenPostingStatus({{$data->id}})"
                                            title="Double Click For Update">
                                            @if($data->posting_status == 1)<span class="textSize badge badge-success">
                                                Posted </span>

                                            @elseif($data->posting_status ==2)<span
                                                class="textSize badge badge-danger">Missed</span>

                                            @else<span class="badge">N/A</span>
                                            @endif
                                        </div>
                                        <div id="{{'updatePostingStatus'.$data->id}}" class="col-md-12" hidden>
                                            <div class="form-group workStatus">
                                                @if ($Orders->order_status == 10 || $Orders->order_status == 7 || $Orders->order_status == 11)
                                                <select disabled class="form-control custom-select">
                                                    @else
                                                    <select id="workStatus" onchange="postingStatus(this)"
                                                        class="form-control custom-select">
                                                        @endif
                                                        <option value="" disabled selected>Select One</option>
                                                        <option value="1" {{($data->posting_status ==1)?'selected':''}}>
                                                            <span class="textSize badge badge-success">Posted</span>
                                                        </option>
                                                        <option value="2" {{($data->posting_status ==2)?'selected':''}}>
                                                            <span class="textSize badge badge-info"> Missed </span>
                                                        </option>

                                                        <input type="hidden" id="workId" value="{{$data->id}}">

                                                    </select>
                                            </div>
                                        </div>
                                    </td>
                                    <!-- End Posting Status  -->

                                    <td class="state1">
                                        @if($data->created_date != null)
                                            {{date('m/d/Y', strtotime($data->created_date))}}
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                    <td class="state">
                                        <div id="{{'viewStatus'.$data->id}}" ondblclick="getOpen({{$data->id}})" title="Double Click For Update">
                                            @if($data->work_details_status ==1)<span
                                                class="textSize badge badge-info">Alive</span>
                                            @elseif($data->work_details_status ==2)<span
                                                class="textSize badge badge-success">Alive Ok</span>
                                            @elseif($data->work_details_status ==3)<span
                                                class="textSize badge badge-danger">Duplicate</span>
                                            @elseif($data->work_details_status ==4)<span
                                                class="textSize badge badge-warning ">Dropped</span>
                                            @elseif($data->work_details_status ==5)<span
                                                class="textSize badge badge-danger">Wrong Text</span>
                                            @else<span class="badge">N/A</span>
                                            @endif
                                        </div>
                                        <div id="{{'updateStatus'.$data->id}}" class="col-md-12" hidden>
                                            <div class="form-group workStatus">
                                                @if ($Orders->order_status == 10 || $Orders->order_status == 7 || $data->work_details_status !=2 || $Orders->order_status == 11)
                                                <select disabled class="form-control custom-select">
                                                    @else
                                                    <select id="workStatus" onchange="checkbox(this)"
                                                        class="form-control custom-select">
                                                        @endif
                                                        <option value="2" disabled
                                                            {{($data->work_details_status ==2)?'selected':''}}>
                                                            <span class="textSize badge badge-success">Alive Ok</span>
                                                       </option>
                                                        <option value="1" disabled
                                                            {{($data->work_details_status ==1)?'selected':''}}>
                                                            <span class="textSize badge badge-info">Alive</span>
                                                        </option>

                                                        <option value="3"
                                                            {{($data->work_details_status ==3)?'selected':''}}>
                                                            <span class="textSize badge badge-danger">Duplicate</span>
                                                        </option>
                                                        <option value="4"
                                                            {{($data->work_details_status ==4)?'selected':''}}>
                                                            <span class="textSize badge badge-warning">Dropped</span>
                                                        </option>
                                                        <option value="5"
                                                            {{($data->work_details_status ==5)?'selected':''}}>
                                                            <span class="textSize badge badge-danger">Wrong Text</span>
                                                        </option>
                                                        <input type="hidden" id="workId" value="{{$data->id}}">

                                                    </select>
                                            </div>
                                        </div>
                                    </td>
                                    {{-- <input type="hidden" id="workId" value="{{$data->id}}"> --}}
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @else
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Work U_Id</th>
                                    <th>Install Date</th>
                                    <th>Keyword</th>
                                    <th>Country</th>
                                    <th>Country Code</th>
                                    <th>osVersion</th>
                                    <th>IDFA</th>
                                    <th>IP</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($datas as $key=>$data)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td><a href="#" target="_blank">{{$data->work_details_u_id}}</a></td>
                                    <td>{{date('m/d/Y', strtotime($data->install_date))}}</td>
                                    <td>{{$data->keyword}}</td>
                                    <td>{{$data->country}}</td>
                                    <td>{{$data->country_code}}</td>
                                    <td>{{$data->os_version}}</td>
                                    <td>{{$data->idfa}}</td>
                                    <td>{{$data->ip}}</td>
                                    <td class="state">
                                        <div id="{{'viewStatus'.$data->id}}" ondblclick="getOpen({{$data->id}})" title="Double Click For Update">
                                            @if($data->work_details_status ==1)<span
                                                class="textSize badge badge-info">Alive</span>
                                            @elseif($data->work_details_status ==2)<span
                                                class="textSize badge badge-success">Alive Ok</span>
                                            @elseif($data->work_details_status ==3)<span
                                                class="textSize badge badge-danger">Duplicate</span>
                                            @elseif($data->work_details_status ==4)<span
                                                class="textSize badge badge-warning ">Dropped</span>
                                            @elseif($data->work_details_status ==5)<span
                                                class="textSize badge badge-danger">Wrong Text</span>
                                            @else<span class="badge">N/A</span>
                                            @endif
                                        </div>
                                        <div id="{{'updateStatus'.$data->id}}" class="col-md-12" hidden>
                                            <div class="form-group workStatus">
                                                @if ($Orders->order_status == 10 || $Orders->order_status == 7 || $Orders->order_status == 11 || $data->work_details_status !=2)
                                                <select disabled class="form-control custom-select">
                                                    @else
                                                    <select id="workStatus" onchange="checkbox(this)"
                                                        class="form-control custom-select">
                                                        @endif
                                                        <option value="2" disabled
                                                            {{($data->work_details_status ==2)?'selected':''}}>
                                                            <span class="textSize badge badge-success">Alive Ok</span>
                                                       </option>
                                                        <option value="1" disabled
                                                            {{($data->work_details_status ==1)?'selected':''}}>
                                                            <span class="textSize badge badge-info">Alive</span>
                                                        </option>

                                                        <option value="3"
                                                            {{($data->work_details_status ==3)?'selected':''}}>
                                                            <span class="textSize badge badge-danger">Duplicate</span>
                                                        </option>
                                                        <option value="4"
                                                            {{($data->work_details_status ==4)?'selected':''}}>
                                                            <span class="textSize badge badge-warning">Dropped</span>
                                                        </option>
                                                        <option value="5"
                                                            {{($data->work_details_status ==5)?'selected':''}}>
                                                            <span class="textSize badge badge-danger">Wrong Text</span>
                                                        </option>
                                                        <input type="hidden" id="workId" value="{{$data->id}}">

                                                    </select>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @endif

                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>


    <div class="modal fade" id="dialog" style="display:none">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Add Reason</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col">

                            <form>
                                <input type="hidden" name="vandor_id" id="vandor_id1">
                                <input type="hidden" name="order_id" id="order_id1">
                                <input type="hidden" name="assign_id" id="assign_id1">
                                <input type="hidden" name="work_id" id="work_id1">

                                <div class="row">
                                    <div class="col-12">

                                        <div class="row">
                                            <!-- 3rd Row -->
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <h5>Reason For Refilling <span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <textarea type="text" name="rsn" id="rsn" class="form-control"
                                                            required=""></textarea>
                                                    </div>
                                                </div>
                                            </div> <!-- End Col md 4 -->
                                        </div> <!-- End 3rd Row -->

                                        <div class="row" style="margin-top: 20px">
                                            <!-- 7TH Row -->
                                            <div class="col-md-5">
                                                <div class="text-xs-right">
                                                    <input type="submit" onclick="Submit()"
                                                        class="btn btn-rounded btn-primary mb-5" value="Submit">
                                                </div>
                                            </div>
                                        </div> <!-- End 7TH Row -->
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- /.col -->
                    </div>
                    <!-- /.row -->
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->
</section>

<script>
    $('.newOrderAdd').submit(function(){
     $(this).find(':submit').attr( 'disabled','disabled' );
     //the rest of your code
    setTimeout(() => {
        $(this).find(':submit').attr( 'disabled',false );
    }, 2000);
});
</script>

<script type="text/javascript">

    function value(r) {
        var id = r;
        console.log(id);
    };

    function checkbox(_this) {
        var p_state = $(_this).closest('tr').find('#state').text(); // get the text
        var p_status = _this.value; // get the selected value
        var id = $(_this).closest('td').find('#workId').val();
        console.log(p_status);
        console.log(id);

        if (id != '') {
            $.ajax({
                url: "updateWorkDetailsStatusC",
                method: "GET",
                data: {
                    id: id,
                    p_status: p_status,
                },
                dataType: "JSON",
                success: function (data) {
                    toastr.success(" Update Status ");
                    $("#dialog").modal('show');
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }

</script>

<script>
    function assignStatus(r) {
        //console.log(r);
        var value = r.value;
        var id = $('#order_id').val();
        console.log(value);

        if (value == 5) {
            $("#dialog").modal('show');
        } else {

            if (id != '') {
                $.ajax({
                    url: "updateOrderStatusC",
                    method: "GET",
                    data: {
                        id: id,
                        value: value,
                    },
                    dataType: "JSON",
                    success: function (data) {

                        var type = data.order_status;

                        if(type == 1){
                            toastr.success(" Order Resumed ");
                        }else if(type == 3){
                            toastr.info(" Work In Progress ");
                        }else if(type == 4){
                            toastr.success(" Order Finished ");
                        }else if(type == 5){
                            toastr.warning(" Order Refilling ");
                        }else if(type == 6){
                            toastr.success(" Order Refilled ");
                        }else if(type == 7){
                            toastr.error(" Hold ");
                        }else if(type == 10){
                            toastr.success(" Order Completed ");
                        }else if(type == 11){
                            toastr.success(" Order Canceled ");
                        }else{
                            toastr.success(" Updated !");
                        }

                        setTimeout(function() {
                            window.location.reload();
                        }, 1000);
                    }
                })
            } else {
                alert("Something is wrong ..!!");
            }
        }
    }

    function Submit() {
        //console.log(r);
        var value = 5;
        var id = $('#order_id').val();
        var rsn = $('#rsn').val();
        console.log(id);
        console.log(rsn);


        if (id != '' && rsn != '') {
            $.ajax({
                url: "updateStatusOfOrder",
                method: "GET",
                data: {
                    id: id,
                    value: value,
                    rsn: rsn,
                },
                dataType: "JSON",
                success: function (data) {
                    console.log(data);
                    if (data.order_status != null) {
                        toastr.warning(" Order Refilling ");
                    }
                    $('#rsn').val('');
                    $("#dialog").modal('hide');

                }
            })
        } else {
            Swal.fire({
                title: 'Are you sure?',
                text: "You Don't Add Empty Field",
                icon: 'warning',
                // showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, Close it!'
            })
        }
    }

</script>

<script>
    function getOpen(r)
    {
        console.log(r);
        $('#updateStatus'+r).removeAttr('hidden');
        $('#viewStatus'+r).attr('hidden','');
    }
</script>

<!-- posting status Start-->
<script>
    function getOpenPostingStatus(r) {
        console.log(r);
        $('#updatePostingStatus' + r).removeAttr('hidden');
        $('#viewPostingStatus' + r).attr('hidden', '');
    }

    function postingStatus(_this) {
        var p_state = $(_this).closest('tr').find('#state').text(); // get the text
        var posting_status = _this.value; // get the selected value
        var id = $(_this).closest('td').find('#workId').val();
        console.log(posting_status);
        console.log(id);

        if (id != '') {
            $.ajax({
                url: "updatePostingStatus",
                method: "GET",
                data: {
                    id: id,
                    posting_status: posting_status,
                },
                dataType: "JSON",
                success: function (data) {
                    console.log(data);
                    toastr.success(" Status Update ");

                    // setTimeout( function(){
                    //     window.location.reload(true);
                    // }  , 1000 );


                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }

</script>

@endsection
