@extends('admin.masterBlade')

@section('title')
    Payment Methods
@endsection

@section('content')

    <!-- Main content -->
    <section class="content" style="padding-top: 20px;">
        <div class=" col-md-6">
            <div class="card card-success table-responsive">
                <div class="card-header">
                    <h5 class="m-0 text-white">Payment Methods List
                        <a href="#" title="" data-toggle="modal" data-target="#addMenu">
                            <i class="fas fa-plus-circle" style="float: right; font-size:25px;"></i>
                        </a>
                        <a href="{{url('view-system-config')}}">
                            <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px; padding-right:20px"></i>
                        </a>
                    </h5>
                </div>
                <div class="card-body">
                    <table id="example1" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Operator</th>
                                <th>Payment Methods Name</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; ?>
                            @foreach ($menu as $row)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>
                                    @if ($row->created_by != null)
                                        {{ $row->operator->name }}
                                    @endif
                                </td>
                                <td><a href="">{{ $row->name }}</a></td>
                                <td>
                                    @if ($row->status == 1)
                                        <span class="badge badge-success">Active</span>
                                    @elseif($row->status == 2)
                                        <span class="badge badge-info">Update</span>
                                    @elseif($row->status == 0)
                                        <span class="badge badge-danger">Delete</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-info">Action</button>
                                        <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                            data-toggle="dropdown">
                                            <span class="sr-only">Toggle Dropdown</span>
                                        </button>
                                        <div class="dropdown-menu dropdown-content" role="menu">
                                            @if( Auth::user()->role == 1 || Auth::user()->role == 2 )
                                                <a class="dropdown-item" data-toggle="modal"
                                                    data-target="#editMenu" onclick="getDataA('<?php echo $row->id ?>','<?php echo $row->name ?>')" href="editMenu">
                                                    <span class="fa fa-edit" style="padding-right:10px;"></span> Edit
                                                </a>
                                                <?php $findMenu = App\Models\EmployeeSalary::where('payment_method_id', $row->id)->first(); ?>
                                                @if($findMenu == null)
                                                    <a class="dropdown-item" id="delete" href="{{url('destroy-payment-method-'.$row->id)}}"><i class="fas fa-trash"
                                                        style="padding-right:10px; "></i> Delete</a>
                                                @endif

                                            @else
                                                <a class="dropdown-item">No Action</a>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Add Modal -->
        <div class="modal fade" id="addMenu">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Add Payment Methods</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form action="{{route('store-payment-method')}}" enctype="multipart/form-data" method="post">
                            @csrf
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div class="row form-group ">
                                                <label class="col-md-4">Name</label>
                                                <input type="text" name="name" class="form-control col-md-8"  placeholder="Payment Methods Name">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer justify-content-between">
                                <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
        <!-- Add Modal -->

        <!-- Update Modal -->
        <div class="modal fade" id="editMenu">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Update Payment Methods</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form action="{{route('update-payment-method')}}" enctype="multipart/form-data" method="post">
                            @csrf
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div class="row form-group ">
                                                <label class="col-md-4">Name</label>
                                                <input type="text" id="menuName" name="name" class="form-control col-md-8"  placeholder="Payment Methods Name">
                                            </div>
                                            <input type="hidden" id="menuID" name="id">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer justify-content-between">
                                <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
        <!-- Update Modal -->

        <script>
            function getDataA(id, name) {
                $("#menuID").val(id);
                $("#menuName").val(name);
            }
        </script>

    </section>

@endsection

