@extends('admin.masterBlade')

@section('title')
General Expense List
@endsection

@section('content')

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-10">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">General Expense List
                            <a href="#" title="" data-toggle="modal" data-target="#modal-xl">
                                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Transaction ID</th>
                                    <th>Expense Name</th>
                                    <th>Amount</th>
                                    <th>Transaction Date</th>
                                    <th>Reason</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($datas as $key=>$genExp)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>
                                        @if($genExp->transactionID != null)
                                            {{ $genExp->transactionID }}
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                    <td>{{$genExp->ExpenseName->name }}</td>
                                    <td>{{$genExp->amount }}</td>
                                    <td>{{$genExp->date}}</td>
                                    <td>{{$genExp->reason }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">
                                                @if(Auth::user()->role == 1 || Auth::user()->role == 2)
                                                <a class="dropdown-item" href="{{url('edit-general-expense-'.$genExp->id)}}"><span
                                                        class="fa fa-edit" style="padding-right:10px;"></span> Edit</a>
                                                <a class="dropdown-item" id="delete" href="{{url('delete-general-expense-'.$genExp->id)}}"><span
                                                        class="fa fa-trash" style="padding-right:10px;"></span> Delete</a>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

<div class="modal fade" id="modal-xl">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add General Expense</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form id="createGexForm" method="post" action="{{url('store-general-expense')}}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="row" >
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <h5>Expense <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="expense_type_id" id="expense_type_id" required="" class="form-control">
                                                        <option value="" selected="" disabled="">Select Expense
                                                        </option>
                                                        @foreach ($expType as $item)
                                                           <option value="{{$item->id}}">{{$item->name}}</option>
                                                        @endforeach

                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div>

                                    <div class="row" >
                                        <div class="col-md-12">
                                            <h5>Transaction ID</h5>
                                            <div class="form-group">
                                                <input type="text" class="form-control" name="transactionID" >
                                             </div>
                                        </div> <!-- End Col md 4 -->
                                    </div>

                                    <div class="row" >
                                        <div class="col-md-6">
                                            <h5>Transaction Date <span class="text-danger">*</span></h5>
                                            <div class="form-group">
                                                <input type="date" class="form-control" name="date" id="date" required="">
                                             </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-6">
                                            <h5>Amount <span class="text-danger">*</span></h5>
                                            <div class="form-group">
                                               <input type="number" class="form-control" step="0.01" min="0" max="{{ $accountsTotal->total }}" name="amount" placeholder="Annount" id="amount" required="">
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="row form-group ">
                                            <span style="color :red; padding-left:15px">
                                                You Can not Expense more than ( <b>${{ $accountsTotal->total }}</b> ) current amount.
                                            </span>
                                        </div>
                                        <input type="hidden" id="accountsTotal" value="{{ $accountsTotal->total }}">

                                    </div>

                                    <div class="row" >
                                        <div class="col-md-12">
                                            <h5>Reason </h5>
                                            <div class="form-group">
                                               <textarea type="text" rows="6" name="reason" class="form-control" placeholder="Write Reason About General Expense"></textarea>
                                             </div>
                                        </div> <!-- End Col md 4 -->
                                    </div>

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" id="createGexBtn" value="Submit">
                                            </div>
                                        </div>

                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<script>
    $("#createGexBtn").click(function () {
        $(this).attr("disabled", "disabled");
        $('#createGexForm').submit();
        setTimeout('$("#createGexBtn").removeAttr("disabled")', 1500);
    });
    $("#updateGexBtn").click(function () {
        $(this).attr("disabled", "disabled");
        $('#updateGexForm').submit();
        setTimeout('$("#updateGexBtn").removeAttr("disabled")', 1500);
    });
</script>

<script type="text/javascript">

    $(document).ready(function () {
        $(document).on('keyup change','#amount',function(){
            var amount = parseFloat($('#amount').val());
            var accountsTotal = parseFloat($('#accountsTotal').val());

            // console.log(amount);

            if( amount > accountsTotal ) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'You can not Give more than Accounts Total Amount !!!',
                });

                $('#amount').val(0.0);
            }
        });
    });

</script>


@endsection
