@extends('admin.masterBlade')

@section('title')
Expense Type
@endsection
@section('content')

<section class="content" style="padding: 10px;">
    <div class="container-fluid">
        <div class="row content-center">
            <div class="col-md-8">
                <div class="card card-success table-responsive" style="margin-top:10px;">

                    <div class="card-header">
                        <h5 class="m-0 text-white text-center">Expense Type
                            <a href="#" title="" data-toggle="modal" data-target="#modal-lg">
                                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>

                            </a>
                            <a href="javascript:history.back()">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>
                    <!-- /.box-header -->
                    <div class="card-body">

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Expense Type</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>


                                @foreach($costs as $key=>$cost)

                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$cost->expense_name}}</td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">
                                                <a class="dropdown-item" href="{{url('expense-type-edit-'.$cost->id)}}">
                                                    <i class="fas fa-edit"
                                                        style="padding-right:10px;"></i>Edit</a>
                                            
                                                <a class="dropdown-item" href="{{url('expense-type-delete-'.$cost->id)}}">
                                                    <i class="fas fa-trash-alt" style="padding-right:10px;"></i>Delete</a>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

<div class="modal fade" id="modal-lg">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Expense</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('store-expense-type-data')}}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->                    
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <h5>Type</h5>
                                                    <div class="controls">
                                                        <input type="text" name="expense_name" class="form-control">
                                                    </div>
                                                </div>
                                            </div> <!-- End Col md 4 -->
                                        </div> <!-- End 1stRow -->

                                        <div class="row" style="margin-top: 20px">
                                            <!-- 7TH Row -->
                                            <div class="col-md-5">
                                                <div class="text-xs-right">
                                                    <input type="submit" class="btn btn-rounded btn-primary mb-5"
                                                        value="Submit">
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                            </div>
                                        </div> <!-- End 7TH Row -->
                                    </div>
                                </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->

    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
@endsection
