<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">Update Client Logo</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>

        <form action="{{route('update-client-logo')}}" enctype="multipart/form-data" method="post"
            style="padding: 10px">
            @csrf
            <div class="modal-body">

                <div class="form-group">

                    <input type="hidden" name="id" id="id">

                    <div class="row form-group">
                        <label class="col-md-5">Company Link <span class="text-danger">*</span></label>
                        <input type="text" name="company_link" id="company_link" class="form-control col-md-7" required
                            placeholder="http://order.proreviewapps.com/">
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Logo alt Name </label>
                        <input type="text" name="image_alt_name" id="image_alt_name" class="form-control col-md-7"
                            placeholder="Logo alt Name">
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Client Logo <span class="text-danger">*</span></label>
                        <input type="file" name="image" id="image" class="form-control col-md-7">
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5"></label>
                        <img id="showImage"
                            src="{{(!empty($data->image)) ? url('upload/userImage/'.$data->image):url('upload/NoImage.png')}}"
                            style="width: 100px; height: 110px; border: 1px solid #000000;">
                    </div>

                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->

<script type="text/javascript">
function getDataA(clientLogoId) {
    $.ajax({
        url: "findClientLogo", // path to function
        method: "GET",
        data: {

            clientLogoId: clientLogoId
        },
        dataType: "JSON",

        success: function(res) {
            $("#id").val(res.id);
            $("#company_link").val(res.company_link);
            $("#image_alt_name").val(res.image_alt_name);

            var url = 'upload/clientLogo/' + res.image;
            // console.log('upload/clientLogo/'+res.image);
            $("#showImage").attr('src', url);
        },
    });
}

$(document).ready(function() {
    $('#image').change(function(e) {
        var reader = new FileReader();
        reader.onload = function(e) {
            $('#showImage').attr('src', e.target.result);
        }
        reader.readAsDataURL(e.target.files['0']);
    });
});
</script>