<?php
    $currentURLs = URL::current(); // current url with domain name
    $currentURL = request()->path(); // current url without domain name
    // dd($currentURL);
    $findRole = DB::table('admin_role')->where('url', $currentURL)->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>

@extends('admin.masterBlade')

@section('title')
    Client Logo List
@endsection

@section('content')

@if($findRole->url == $currentURL )

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-success table-responsive" style="margin-top:20px;">
                        <div class="card-header text-center">
                            <h5 class="m-0 text-white">Client Logo List
                                <a href="#" title="" data-toggle="modal" data-target="#adds-budget">
                                    <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                                </a>
                            </h5>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Operator</th>
                                        <th>Logo</th>
                                        <th>Logo alt Name</th>
                                        <th>Link</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($clientLogo as $key => $data)
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>
                                            @if($data->created_by != null)
                                                {{$data->operator->name }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>
                                            <img class="profile-user-img img-fluid img-circle" 
                                            src="{{(!empty($data->image)) ? url('upload/clientLogo/'.$data->image):url('upload/NoImage.png')}}" 
                                            alt="{{ $data->image_alt_name ?? 'N/A' }}">
                                        </td>
                                        <td>{{ $data->image_alt_name ?? 'N/A' }}</td>
                                        <td>
                                            {{$data->company_link}}
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-info">Action</button>
                                                <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                    data-toggle="dropdown">
                                                    <span class="sr-only">Toggle Dropdown</span>
                                                </button>
                                                <div class="dropdown-menu dropdown-content" role="menu">
                                                    @if(Auth::user()->role == 1 || Auth::user()->role == 2)
                                                        <a class="dropdown-item" data-toggle="modal" data-target="#edit-budget"
                                                            onclick="getDataA('<?php echo $data->id ?>')" href="#"><span
                                                            class="fa fa-edit" style="padding-right:10px;"></span> Edit</a>
                                                    @endif
                                                    @if(Auth::user()->role == 1)
                                                        <a class="dropdown-item" id="delete" href="{{url('destroy-client-logo-'.$data->id)}}"><span
                                                            class="fa fa-trash" style="padding-right:10px;"></span> Delete</a>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

    <!-- /Add client-logo Modal Start -->
    <div class="modal fade" id="adds-budget">
        @include('admin.page.manageWebsites.clientLogo.create')
    </div>
    <!-- /Add client-logo Modal End -->

    <!-- /Edit client-logo Modal Start -->
    <div class="modal fade" id="edit-budget">
        @include('admin.page.manageWebsites.clientLogo.update')
    </div>
    <!-- /Edit client-logo Modal End -->

    @else
        @include('admin.404')
    @endif

@endsection
