<?php
    $currentURLs = URL::current(); // current url with domain name
    $currentURL = request()->path(); // current url without domain name
    $findRole = DB::table('admin_role')->where('url', $currentURL)->where('admin_id', Auth::user()->id)->first();
?>

@extends('admin.masterBlade')

@section('title')
    Blog List
@endsection

@section('content')

@if($findRole->url == $currentURL )

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-success table-responsive" style="margin-top:20px;">
                        <div class="card-header text-center">
                            <h5 class="m-0 text-white">Blog List
                                <a href="#" title="" data-toggle="modal" data-target="#create-blog">
                                    <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                                </a>
                            </h5>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Operator</th>
                                        <th>Title</th>
                                        <th>Image</th>
                                        <th>Image alt Name</th>
                                        <th>Date</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($blog as $key => $data)
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>
                                            @if($data->created_by != null)
                                                {{$data->operator->name }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>{{$data->title}}</td>
                                        <td>
                                            <img class="profile-user-img img-fluid " 
                                            src="{{(!empty($data->image)) ? url('upload/blog/'.$data->image):url('upload/NoImage.png')}}" 
                                            alt="{{ $data->image_alt_name ?? 'N/A' }}">
                                        </td>
                                        <td>{{ $data->image_alt_name ?? 'N/A' }}</td>
                                        <td>{{$data->created_date}}</td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-info">Action</button>
                                                <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                    data-toggle="dropdown">
                                                    <span class="sr-only">Toggle Dropdown</span>
                                                </button>
                                                <div class="dropdown-menu dropdown-content" role="menu">
                                                    @if(Auth::user()->role == 1 || Auth::user()->role == 2)
                                                        <a class="dropdown-item" href="{{url('details-blog-'.$data->id)}}"><span
                                                            class="fa fa-eye" style="padding-right:10px;"></span> Details</a>
                                                        <a class="dropdown-item" href="{{url('edit-blog-'.$data->id)}}"><span
                                                            class="fa fa-edit" style="padding-right:10px;"></span> Edit</a>
                                                    @endif
                                                    @if(Auth::user()->role == 1)
                                                        <a class="dropdown-item" id="delete" href="{{url('destroy-blog-'.$data->id)}}"><span
                                                            class="fa fa-trash" style="padding-right:10px;"></span> Delete</a>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

    <!-- /Add Blog Modal Start -->
    <div class="modal fade" id="create-blog">
        @include('admin.page.manageWebsites.blog.create')
    </div>
    <!-- /Add Blog Modal End -->

    @else
        @include('admin.404')
    @endif

@endsection
