<div class="modal-dialog modal-xl">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">Add Blog</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>

        <form action="{{route('store.blog')}}" enctype="multipart/form-data" method="post" style="padding: 10px">
            @csrf
            <div class="modal-body">

                <div class="form-group">
                    <div class="row ">
                        <div class="col-md-6 form-group">
                            <label>Title <span class="text-danger">*</span></label>
                            <input type="text" name="title" class="form-control" required placeholder="Title goes here...">
                        </div>
                        <div class="col-md-6 form-group">
                            <label>Image Alt Name </label>
                            <input type="text" name="image_alt_name" class="form-control" placeholder="Image alt attributes name">
                        </div>

                        <div class="col-md-6 form-group">
                            <label>Image <span class="text-danger">*</span></label>
                            <input type="file" name="image" id="image" class="form-control" required>
                        </div>
                        <div class="col-md-6 form-group">
                            <img id="showImage" src="{{url('upload/NoImage.png')}}"
                                style="width: 150px; height: 100px; border: 1px solid #000000;">
                        </div>
                    </div>
                    <div class=" form-group">
                        <label class="">Blog Details <span class="text-danger">*</span></label>
                        <textarea id="summernote" name="description" rows="8" required></textarea>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->


<script type="text/javascript">
    $(document).ready(function () {
        $('#image').change(function (e) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('#showImage').attr('src', e.target.result);
            }
            reader.readAsDataURL(e.target.files['0']);
        });
    });
</script>