@extends('admin.masterBlade')

@section('title')
All Client
@endsection

@section('content')

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">All Client List
                            <a href="#" title="" data-toggle="modal" data-target="#modal-xl">
                                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>

                            </a>
                            <a href="javascript:history.back()">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>

                    <!-- /.card-header -->
                    <div class="card-body">
                        <!-----------------------Active/Inactive Button--------------------->
                        <div class="btn-group " style="float: right; padding-right:10px;">
                            <button type="button"
                                class="btn btn-success dropdown-toggle dropdown-icon btn-sm"
                                data-toggle="dropdown">All
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <div class="dropdown-menu dropdown-content" role="menu"  style="padding-right:10px;">

                                <a class="dropdown-item"
                                    href="{{url('view-active-employee')}}"><i class="fas fa-check"
                                    style="padding-right:10px;"></i>Active</a>
                                <a class="dropdown-item"
                                    href="{{url('view-inative-employee')}}" ><i class="fas fa-times-circle"
                                    style="padding-right:10px; "></i>
                                    InActive</a>
                                <a class="dropdown-item text-white"
                                        href="javascript:void(0)" style="background-color:#28a745;">
                                        <i class="far fa-list-alt"
                                        style="padding-right:10px;"></i>View All</a>
                            </div>
                        </div>

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Address</th>
                                    <th>Gender</th>
                                    <th>Date of Birth</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($clients as $key=>$user)
                                <tr @if($user->status == 4) style="background-color: #e5ac00;" class="text-white" @endif >
                                    <td>{{$key+1}}</td>
                                    <td><a href="{{url('view-employee-profile-'.$user->id)}}">{{$user->name}}</a></td>
                                    <td>{{$user->email }}</td>
                                    <td>{{$user->phone}}</td>
                                    <td>{{$user->address}}</td>
                                    <td>{{$user->gender}}</td>
                                    @if($user->dob==null) <td>N/A</td> @else<td>{{$user->dob}}</td>@endif
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">
                                                @if(Auth::user()->role == 1 || Auth::user()->role == 2)
                                                <a class="dropdown-item" href="{{url('edit-client-profile-'.$user->id)}}"><span
                                                        class="fa fa-edit" style="padding-right:10px;"></span> Edit</a>
                                                    @if($user->status == 4)
                                                        <a class="dropdown-item" href="{{url('active-client-'.$user->id)}}"><i class="fas fa-times-circle"
                                                            style="padding-right:10px; "></i> Active</a>
                                                    @else
                                                        <a class="dropdown-item" href="{{url('inactive-client-'.$user->id)}}"><i class="fas fa-times-circle"
                                                            style="padding-right:10px; "></i> InActive</a>
                                                    @endif
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>
<div class="modal fade" id="modal-xl">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Vendor</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('store-employee-data')}}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Full Name <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="name" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Mobile Number <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="text" name="phone" class="form-control" required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Gender <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="gender" id="gender" required="" class="form-control">
                                                        <option value="" selected="" disabled="">Select Gender
                                                        </option>
                                                        <option value="Male">Male</option>
                                                        <option value="Female">Female</option>
                                                        <option value="Other">Other</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                    </div> <!-- End 1stRow -->
                                    <div class="row">
                                        <!-- 2nd Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Email <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="email" name="email" class="form-control" id="email"  required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Password <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="password" name="password" class="form-control" required="" id="password">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Confirm Password <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="password" name="Cpassword" class="form-control" id="cpassword" required="">
                                                    <span id='message'></span>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 2nd Row -->
                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <h5>Address</h5>
                                                <div class="controls">
                                                    <textarea type="text" name="address" class="form-control"></textarea>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <h5>Date of Birth </h5>
                                                <div class="controls">
                                                    <input type="date" name="dob" class="form-control">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                         <!-- 4th Row -->
                                         <div class="col-md-3">
                                            <div class="form-group">
                                                <h5>Profile Image</h5>
                                                <div class="controls">
                                                    <input type="file" name="image" class="form-control" id="image">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <img id="showImage" src="{{ url('upload/NoImage.png') }}"
                                                        style="width: 100px; height: 110px; border: 1px solid #000000;">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 3rd Row -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<div class="modal fade" id="modal-default">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">

                        <div class="login-box col-md-12" >
                            <div class="card card-outline card-primary" style="background-color: #001f3f">
                                <div class="card-header text-center text-white">
                                    <a  class="h1"><b>Password</b>Reset</a>
                                </div>
                                <div class="card-body">
                                    <p class="login-box-msg text-white">You are only one step a way from your new password, Update your
                                        password now.</p>
                                    <form action="{{url('users-update-password')}}" method="post">
                                        @csrf
                                        <input type="hidden" id="id" name="id">
                                        <div class="input-group mb-3">
                                            <input type="password" name="c_password" id="c_password" class="form-control" placeholder="Password">
                                            <div class="input-group-append">
                                                <div class="input-group-text">
                                                    <span class="fas fa-lock"></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="input-group mb-3">
                                            <input type="password" id="con_password" name="con_password" class="form-control" placeholder="Confirm Password">
                                            <div class="input-group-append">
                                                <div class="input-group-text">
                                                    <span class="fas fa-lock"></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <button type="submit" id="Sub" class="btn btn-primary btn-block">Change password</button>
                                            </div>
                                            <!-- /.col -->
                                        </div>
                                    </form>

                                    <p class="mt-3 mb-1">
                                        <a href="{{url('manage-employee')}}"><b>Back</b></a>
                                    </p>
                                </div>
                                <!-- /.login-card-body -->
                            </div>
                        </div>
                        <!-- /.login-box -->

                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<!-------------------------/.password Check------------------------------>
<script>
    $('#c_password, #con_password').on('keyup', function () {
        if ($('#c_password').val() == $('#con_password').val())
        {
          $("#con_password").removeClass('form-control is-invalid').addClass('form-control is-valid');
          $("#Sub").removeAttr("disabled");

        }
        else
        {
            $("#con_password").removeClass('form-control is-valid').addClass('form-control is-invalid');
            $("#Sub").attr("disabled", true);
        }


      });
</script>
<script>
    function getId(r)
    {
       console.log(r);
       $("#id").val(r);
    }
</script>

<!------------------------- /.view Image ------------------------------>
<script type="text/javascript">
    $(document).ready(function () {
        $('#image').change(function (e) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('#showImage').attr('src', e.target.result);
            }
            reader.readAsDataURL(e.target.files['0']);
        });
    });

</script>

@endsection
