@extends('admin.masterBlade')

@section('title')
Order Report
@endsection

@section('content')

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card mt-3">
                    <div class="card-header">
                        <h5 class="m-0 text-dark">Order Report</h5>
                    </div>

                    <form class="form-horizontal" method="post" action="{{ route('searchOrderReport') }}">
                        @csrf
                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <h5>Select Date <span class="text-danger">*</span></h5>
                                        <div class="controls">
                                            <input type="text" name="dates" class="form-control" value="" required=""
                                                placeholder="Select Date Range">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <h5>Select Type <span class="text-danger">*</span></h5>
                                        <div class="controls">
                                            <select name="type[]" required="" class="form-control multiSelect" multiple
                                                placeholder="Select Type">
                                                <option value="all" highlighted="">All</option>
                                                <option value="ios">iOS</option>
                                                <option value="android">Android</option>
                                                <option value="google">Google</option>
                                                <option value="others">Others</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <h5>Select Client <span class="text-danger">*</span></h5>
                                        <div class="controls">
                                            <select name="clients[]" required="" class="form-control multiSelect"
                                                multiple placeholder="Select Client">
                                                <option value="all" highlighted="">All</option>
                                                @foreach($clients as $client)
                                                <option value="{{ $client->id }}">{{ $client->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-3 mt-4">
                                    <button type="submit" class="btn btn-primary float-right">Search Report</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            @if(count($orders) > 0)
            <div class="col-md-12">
                <div class="card mt-3">
                    <div class="card-header">
                        <h5 class="m-0 text-dark">Order Report Showing from {{ $date_range }}</h5>
                    </div>

                    <div class="card-body">
                        <!-----------------------Active/Inactive Button--------------------->
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Clients</th>
                                    <th>Unique Id</th>
                                    <th>App Link</th>
                                    <th>Platfrom</th>
                                    <th>GEO</th>
                                    <th>Service Type</th>
                                    <th>Last Date</th>
                                    <th>Quantity</th>
                                    <th>Available Work</th>
                                    <th>Service Cost</th>
                                    <th>Budget</th>
                                    <th>Perday Work</th>
                                    <th>KeyWord</th>
                                    <th>Progress</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($orders as $key => $data)
                                @php
                                $flag = 1;
                                @endphp
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td><a href="{{url('client-profile-'.$data->order_creator_id)}}"
                                            target="_blank">{{ $data?->client?->name }}</a></td>
                                    <td><a href="{{url('check-work-onOrder-'.$data->id)}}"
                                            target="_blank">{{$data->order_unique_id}}</a></td>
                                    <td><a href="{{$data->apps_link }}" target="_blank">Link</a></td>
                                    <td>{{$data->platform}}</td>
                                    <td>{{$data->geo}}</td>
                                    <td>{{$data->service->name}}</td>
                                    <td>{{$data->target_date}}</td>
                                    <td>{{$data->total_quantity}}</td>
                                    <td>{{$data->available_quantity}}</td>
                                    <td>{{$data->service_cost}}</td>
                                    <td>{{$data->total_budget}}</td>
                                    <td>{{$data->perday}}</td>
                                    <td>{{$data->key_word}}</td>
                                    <td>
                                        @foreach ($total as $tData)
                                        @if($tData->o_id == $data->id)
                                        {{$tData->total}}/{{$data->total_quantity}}
                                        @php
                                        $flag = 0;
                                        @endphp
                                        @endif
                                        @endforeach
                                        @if( $flag == 1)
                                        0/{{$data->total_quantity}}
                                        @endif
                                    </td>
                                    <td>
                                        @if($data->order_status ==1)<span
                                            class="textSize badge badge-warning">Pending</span>
                                        @elseif($data->order_status ==2)<span
                                            class="textSize badge badge-info">Accept</span>
                                        @elseif($data->order_status ==3)<span class="textSize badge badge-success">In
                                            Work</span>
                                        @elseif($data->order_status ==4)<span
                                            class="textSize badge badge-warning ">Finished</span>
                                        @elseif($data->order_status ==5)<span
                                            class="textSize badge badge-danger">Refilling</span>
                                        @elseif($data->order_status ==6)<span
                                            class="textSize badge badge-secondary">Refiled</span>
                                        @elseif($data->order_status ==7)<span
                                            class="textSize badge badge-primary">Hold</span>
                                        @elseif($data->order_status ==8)<span
                                            class="textSize badge badge-danger">Decline</span>
                                        @elseif($data->order_status ==9)<span
                                            class="textSize badge badge-secondary">Active</span>
                                        @elseif($data->order_status ==10)<span
                                            class="textSize badge badge-secondary">Completed</span>
                                        @elseif($data->order_status ==11)<span
                                            class="textSize badge badge-danger">Canceled</span>
                                        @else<span class="badge">N/A</span>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
            @endif

        </div>
</section>


<script>
$(function() {
    $('select').each(function() {
        var $select = $(this);

        $select.select2({
            theme: 'bootstrap4',
            width: 'style',
            placeholder: $select.attr('placeholder'),
            allowClear: Boolean($select.data('allow-clear')),
        });

        // Handle "All" option selection
        $select.on('select2:select', function(e) {
            if (e.params.data.id === 'all') {
                $select.find('option:not([value="all"])').prop('selected', true);
                $select.trigger('change');
            } else {
                // Deselect "All" if any other option is deselected
                $select.find('option[value="all"]').prop('selected', false);
                $select.trigger('change');
            }
        });

        // Handle any option deselection
        $select.on('select2:unselect', function(e) {
            // Deselect "All" if any option is deselected
            $select.find('option[value="all"]').prop('selected', false);
            $select.trigger('change');
        });

        // Update placeholder when no option is selected
        $select.on('change', function() {
            var selectedOptions = $(this).val();
            if (!selectedOptions || selectedOptions.length === 0) {
                $(this).siblings('.select2-container').find('.select2-selection__placeholder')
                    .text($(this).attr('placeholder'));
            }
        });
    });
});
</script>



@endsection