<div class="modal-dialog  modal-xl">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title"> Pay Against Order </h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>

        <form action="{{url('client-store-spend-money')}}" enctype="multipart/form-data" method="post" style="padding: 10px">

            @csrf
            <div class="modal-body">

                <div class="form-group row">
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-11">
                                <input type="hidden" name="" id="clientsName" value="{{$id}}"  class="form-control col-md-7" readonly>
                                <div class="row form-group">
                                    <label class="col-md-5">Clients Current Balance </label>
                                    <input type="text" name="" id="currentBalance"  class="form-control col-md-7" readonly>
                                </div>
                                <div class="row form-group">
                                    <label class="col-md-5">Order ID </label>
                                    <input type="text" name="" id="orderID"  class="form-control col-md-7" readonly>
                                </div>
                                <div class="row form-group">
                                    <label class="col-md-5">Service Type </label>
                                    <input type="text" name="" id="serviceName"  class="form-control col-md-7" readonly>
                                </div>

                                <div class="row form-group">
                                    <label class="col-md-5">Quantity </label>
                                    <input type="text" name="" id="quantity"  class="form-control col-md-7" readonly>
                                </div>
                                <div class="row form-group">
                                    <label class="col-md-5">Service Cost </label>
                                    <input type="text" name="" id="serviceCost"  class="form-control col-md-7" readonly>
                                </div>
                                <div class="row form-group">
                                    <label class="col-md-5">Status </label>
                                    <input type="text" name="" id="order_status"  class="form-control col-md-7" readonly>
                                </div>
                                <div class="row form-group">
                                    <label class="col-md-5">Total Cost </label>
                                    <input type="text" name="" id="totalCost"  class="form-control col-md-7" readonly>
                                </div>
                                <div class="row form-group">
                                    <label class="col-md-5">Total Pay </label>
                                    <input type="text" name="" id="totalPay"  class="form-control col-md-7" readonly>
                                </div>

                                <div class="row form-group">
                                    <label class="col-md-5">Complete Works</label>
                                    <input type="text" name="" id="CompleteWorks"  class="form-control col-md-7" readonly>
                                </div>

                                <div class="row form-group">
                                    <label class="col-md-5">Total Due </label>
                                    <input type="text" name="" id="totalDue"  class="form-control col-md-7" readonly>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-6" style="padding-right: 10px">
                        <div class="row form-group">
                            <label class="col-md-5">Payment Method <span class="text-danger">*</span></label>
                            <select name="payment_method_id" id="payment_method_id" required="" class="form-control col-md-7" >
                                <option value="" selected="" disabled="">Select Payment Method
                                </option>
                                @foreach($findPaymentMethods as $payName)
                                    <option value="{{ $payName->id }}">{{ $payName->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="row form-group">
                            <label class="col-md-5">Transaction ID</label>
                            <input type="text" name="transactionID" class="form-control col-md-7" placeholder="Transaction ID">
                        </div>

                        <div class="row form-group">
                            <label class="col-md-5">Pay Now <span class="text-danger">*</span></label>
                            <input type="number" name="payment_amount" id="payNow" min="0" step="0.0001" class="form-control col-md-7" required placeholder="0.00">
                        </div>

                        <span style="color:red; font-weight:bold;">
                            You can't pay more than current balance.
                            Current Balance is: $<i id="currentAmount"></i>
                        </span>

                        <div class="row form-group" style="padding-top:15px">
                            <label class="col-md-5">Due</label>
                            <input type="number" name="due" id="dues" class="form-control col-md-7" readonly placeholder="0.00">
                        </div>

                        <div class="row form-group">
                            <label class="col-md-5">Charge <span class="text-danger">*</span></label>
                            <input type="number" name="charge" id="charge" min="0" step="0.0001" class="form-control col-md-7" required placeholder="Charge">
                        </div>

                        <div class="row form-group">
                            <label class="col-md-5">Total Received Amount<span class="text-danger">*</span></label>
                            <input type="number" id="total_amount" name="total_received_amount" class="form-control col-md-7" readonly required placeholder="Received Total Amount ">
                        </div>

                        <div class="row form-group">
                            <label class="col-md-5">Charge Note</label>
                            <input type="text" name="charge_note" id="charge_note" class="form-control col-md-7" placeholder="Charge Note">
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-5">Transaction Date <span class="text-danger">*</span></label>
                            <input type="date" name="trans_date" id="trans_date" class="form-control col-md-7" max="{{ $today }}" placeholder="Transaction Date" required>
                        </div>
                        <div class="row form-group ">
                            <label class="col-md-5">Note</label>
                            <textarea type="text" rows="3" name="note" id="note" class="form-control col-md-7" placeholder="Note"></textarea>
                        </div>

                        <input type="hidden" name="order_id" id="order_id">
                        <input type="hidden" name="client_id" id="client_id">
                        <input type="hidden" name="" id="payableAmount">
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" id="spendMoneyButton" class="btn btn-primary">Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->

<script type="text/javascript">
    function getOrderId(orderID) {
        // console.log(orderID);

        $.ajax({
            url: "findClientsCurrentBalance", // path to function
            method: "GET",
            data: {

                orderID: orderID
            },
            dataType: "JSON",

            success: function(val) {
                // console.log(val);

                $("#currentBalance").val(val.toFixed(2));
                $("#currentAmount").text(val.toFixed(2));
            },
        });


        $.ajax({
            url: "findCompleteWorksWhenHold", // path to function
            method: "GET",
            data: {

                orderID: orderID
            },
            dataType: "JSON",

            success: function(val) {
                console.log(val);

                if(val != null){
                    $("#CompleteWorks").val(val);
                }else{
                    $("#CompleteWorks").val(0);
                }
            },
        });

        $.ajax({
            url: "findClientsOrder", // path to function
            method: "GET",
            data: {
                orderID: orderID
            },
            dataType: "JSON",
            success: function(res) {
                // console.log(res);
                $("#clientsName").val(res.clientName);
                $("#orderID").val(res.order_unique_id);
                $("#serviceName").val(res.serviceName);
                $("#totalCost").val(res.total_budget);
                $("#totalPay").val(res.total_pay);
                $("#totalDue").val(res.total_due);
                $("#platform").val(res.platform);
                $("#quantity").val(res.total_quantity);
                $("#serviceCost").val(res.service_cost);

                if(res.order_status == 2){
                    $("#order_status").val('Accept');
                }if(res.order_status == 3){
                    $("#order_status").val('Work in progress');
                }if(res.order_status == 4){
                    $("#order_status").val('Finished');
                }if(res.order_status == 5){
                    $("#order_status").val('Refilling');
                }if(res.order_status == 6){
                    $("#order_status").val('Refilled');
                }if(res.order_status == 7){
                    $("#order_status").val('Hold');
                }if(res.order_status == 9){
                    $("#order_status").val('Active');
                }if(res.order_status == 10){
                    $("#order_status").val('Complete');
                }if(res.order_status == 11){
                    $("#order_status").val('Canceled');
                }

                if(res.total_due > 0){
                    $("#payableAmount").val(res.total_due);
                }else{
                    $("#payableAmount").val(res.total_due);
                }
                $("#client_id").val(res.clientID);
                $("#order_id").val(res.id);
            },
        });
    }
</script>

<!-- Edit Withdraw Total amount check with current balance -->
<script type="text/javascript">
    $(document).ready(function () {
        $(document).on('keyup change','#payableAmount, #payNow, #dues, #charge, #total_amount ',function(){
            var payableAmount = parseFloat($('#payableAmount').val());
            var payNow = parseFloat($('#payNow').val());
            var currentBalance = parseFloat($('#currentBalance').val());
            var charge = parseFloat($('#charge').val());
            var total_amount = parseFloat($('#total_amount').val());

            // console.log(payNow);

            var dues = parseFloat(payableAmount - payNow).toFixed(4);
            var total_received_amount = parseFloat(payNow - charge).toFixed(4);

            if(payNow > payableAmount || payNow > currentBalance){
                $("#spendMoneyButton").attr('disabled','disabled');
            }else{
                $("#spendMoneyButton").removeAttr("disabled");
            }

            if( payNow > payableAmount || payNow > currentBalance ) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'You can not Give more than Accounts Total Amount !!!',
                });

                $('#payNow').val(0.0);
                $('#dues').val(0.0);
                $('#total_amount').val(0.0);
            }else{
                $('#dues').val(dues);
                $('#total_amount').val(total_received_amount);
            }
        });
    });
</script>

{{-- Update spend money --}}
