<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">Refund Request</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>

        <form action="{{url('store-client-refund-request')}}" enctype="multipart/form-data" method="post" style="padding: 10px">
            @csrf
            <div class="modal-body">

                <div class="form-group">

                    <div class="row form-group ">
                        <label class="col-md-5">Select Order <span class="text-danger">*</span></label>
                        <select class="col-md-7 form-control select2bs4" name="order_id"  id="selectOrder" required style="width: 58.333%"
                        onchange="findOrderID(this.value)" >
                            <option value="" selected="" disabled="">Select Order</option>
                            @foreach ($findOrder as $order)

                                <?php $getRefundReq = App\Models\ClientRefundRequest::where('order_id', $order->id)->count(); ?>
                                @if($getRefundReq == null)
                                    <option value="{{$order->id}}">Order ID: {{$order->order_unique_id}}, Service Name: {{ $order->service->name }} </option>
                                @else
                                    <option disabled="">N/A</option>
                                @endif
                            @endforeach
                        </select>
                    </div>

                    <span class="row form-group" id="details"></span>
                    <span id="orderID"></span>
                    <span id="serviceCost"></span>
                    <span id="quantity"></span>
                    <span id="totalBudget"></span>
                    <span id="totalPay"></span>
                    <span id="totalDue"></span>
                    <span class="row form-group" id="workDetails"></span>
                    <span id="totalWorks"></span>
                    <span id="totalCost"></span>
                    <span class="row form-group" id="refundAmount"></span>

                    <input type="hidden" id="refundAmounts">

                    <div class="row form-group ">
                        <label class="col-md-5">Payment Methods <span class="text-danger">*</span></label>
                        <select class="col-md-7 form-control select2bs4" name="payment_method_id" id="payMethod" required="" style="width: 58.333%" >
                            <option value="" selected="" disabled="">Select Payment Methods</option>
                            @foreach ($payMethod as $datas)
                                <option value="{{$datas->id}}">{{$datas->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Request Amount ($) <span class="text-danger">*</span></label>
                        <input type="number" name="request_amount" id="reqAmount" min="0.0001" step="0.01" class="form-control col-md-7" placeholder="Received Amount ($)" required>
                    </div>

                    <div class="row form-group ">
                        <label class="col-md-5">Request Date <span class="text-danger">*</span></label>
                        <input type="date" name="req_date" class="form-control col-md-7" max="{{ $today }}" placeholder="Transaction Date" required>
                    </div>
                    <div class="row form-group ">
                        <label class="col-md-5">Note</label>
                        <textarea type="text" rows="5" name="note" class="form-control col-md-7" placeholder="Note"></textarea>
                    </div>

                    <input type="hidden" name="client_id" id="clientsID">
                    <input type="hidden" name="service_type_id" id="servicesID">
                    <input type="hidden" name="refund_status" value="0">

                    <input type="hidden" name="quantity" id="oQuantity">
                    <input type="hidden" name="rate" id="oRate">
                    <input type="hidden" name="total_budget" id="oBudget">

                    <input type="hidden" name="total_work" id="tWork">
                    <input type="hidden" name="total_cost" id="tCost">
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" id="product" class="btn btn-primary">Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->

<script type="text/javascript">
    function findOrderID(findID) {
        // console.log(findID);
        $.ajax({
            url: "getOrderDetails", // path to function
            method: "GET",
            data: {

                findID: findID
            },
            dataType: "JSON",

            success: function(val) {
                // console.log(val);
                $("#details").html('<span class="col-md-12" style="text-align:center; font-weight:bold; font-size:18px">Order Details</span>');
                $("#orderID").html('<span style="font-size:17px"><b>Order ID : ' + val.order_unique_id + '</b></span>, ');
                $("#serviceCost").html('<span style="font-size:17px"><b>Service Cost : $' + val.service_cost + '</b></span>, ');
                $("#quantity").html('<span style="font-size:17px"><b>Quantity : ' + val.total_quantity + '</b></span>, ');
                $("#totalBudget").html('<span style="font-size:17px"><b>Total Budget : $' + val.total_budget + '</b></span>, ');
                $("#totalPay").html('<span style="font-size:17px"><b>Total Pay : $' + val.total_pay + '</b></span>, ');
                $("#totalDue").html('<span style="font-size:17px"><b>Total Due : $' + val.total_due + '</b></span>, <br>');

                $("#clientsID").val(val.order_creator_id);
                $("#servicesID").val(val.service_type_id);
                $("#oQuantity").val(val.total_quantity);
                $("#oRate").val(val.service_cost);
                $("#oBudget").val(val.total_budget);

                // console.log(val.total_quantity);
            },
        });

        // console.log(findID);
        $.ajax({
            url: "getTotalWorks", // path to function
            method: "GET",
            data: {

                findID: findID
            },
            dataType: "JSON",

            success: function(res) {
                // console.log(res);

                if (res > 0) {
                    $("#workDetails").html('<span class="col-md-12" style="text-align:center; font-weight:bold; font-size:18px; padding-top:10px">Works Details</span>');
                    $("#totalWorks").html('<span style="font-size:17px"> <b>Total Works : ' + res + '</b></span>, ');
                    $("#totalWorks").attr('data-id', res);

                    $("#tWork").val(res);
                }
            },
        });

        // console.log(findID);
        $.ajax({
            url: "getTotalCost", // path to function
            method: "GET",
            data: {

                findID: findID
            },
            dataType: "JSON",

            success: function(result) {
                // console.log(result);

                if (result > 0) {
                    $("#totalCost").html('<span style="font-size:17px"><b>Total Cost : $' + parseFloat(result.toFixed(2)) + '</b></span>');
                    $("#totalCost").attr('data-id', result);

                    $("#tCost").val(result);
                }
            },
        });

        // console.log(findID);
        $.ajax({
            url: "getTotalRefundAmount", // path to function
            method: "GET",
            data: {

                findID: findID
            },
            dataType: "JSON",

            success: function(respons) {
                // console.log(respons);

                if (respons > 0) {
                    $("#refundAmount").html('<span style="color:red; padding-left:10px; padding-top:10px; font-size:20px; font-weight:600">You will be able to refund amount up to : <b> $' + parseFloat(respons.toFixed(2)) + '</b></span>');
                    $("#refundAmount").attr('data-id', respons);
                    $("#refundAmounts").val(respons);
                }else{
                    $("#product").attr('disabled','disabled');
                    $("#refundAmount").html('<span style="color:red; padding-left:10px; padding-top:10px; font-size:20px; font-weight:600">You will not be able to refund request.</span>');
                    $("#refundAmount").attr('data-id', respons);
                    $("#refundAmounts").val(0.0);
                }
            },
        });
    }
</script>

<script type="text/javascript">
    $(document).ready(function () {
        $(document).on('keyup change',' #selectOrder, #payMethod, #reqAmount',function(){
            var refundAmount = parseFloat($('#refundAmounts').val());
            var reqAmount = parseFloat($('#reqAmount').val());

            if(reqAmount > refundAmount){
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'You can not request amount more than $'+refundAmount+' !!!',
                });

                $('#reqAmount').val(0.0);
            }

        });
    });

</script>


