<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">Update Withdraw</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>

        <form id="updateWithdrawForm" action="{{url('update-withdraw')}}" enctype="multipart/form-data" method="post" style="padding: 10px">
            @csrf
            <div class="modal-body">

                <div class="form-group">

                    @if(!empty($accountsTotal))
                        <input type="hidden" name="account_id" value="{{ $accountsTotal->id }}">
                    @endif

                    <input type="hidden" name="id" id="withDId">


                    <div class="row form-group">
                        <label class="col-md-5">Transaction ID</label>
                        <input type="text" name="transactionID" id="transactionID" class="form-control col-md-7" placeholder="Transaction ID">
                    </div>

                    <div class="row form-group ">
                        <label class="col-md-5">From Accounts <span class="text-danger">*</span></label>
                        <select class="col-md-7 form-control select" name="payment_method_id" required="" style="width: 58.333%" >
                            <option id="payMethodName" selected="" >Select From Accounts </option>
                            @foreach ($findPaymentMethods as $datas)
                                <option value="{{$datas->id}}">{{$datas->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="row form-group ">
                        <label class="col-md-5">To Account <span class="text-danger">*</span></label>
                        <input type="text" name="to_account" id="to_account" class="form-control col-md-7" required>
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Account Balance ($) </label>
                        @if(!empty($accountsTotal))
                            <input type="number" id="accountsTotal" value="{{ $accountsTotal->total }}" class="form-control col-md-7" readonly>
                        @else
                            <input type="number" id="accountsTotal" value="0.0001" class="form-control col-md-7" readonly>
                        @endif
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Withdraw Amount ($) <span class="text-danger">*</span></label>
                        <input type="number" name="withdraw_amount" id="withdraw_amounts" min="0.0001" step="0.0001" class="form-control col-md-7" placeholder="Withdraw Amount ($)" required>
                    </div>
                    <div class="row form-group">
                        <label class="col-md-5">Exchange Rate <span class="text-danger">*</span></label>
                        <input type="number" name="exchange_rate" id="exchange_rates" min="0.0001" step="0.0001" class="form-control col-md-7" required placeholder="Exchange Rate">
                    </div>
                    <div class="row form-group">
                        <label class="col-md-5">Total Amount (BDT) <span class="text-danger">*</span></label>
                        <input type="number" name="bdt_amount" id="bdt_amounts" class="form-control col-md-7" readonly required placeholder="Withdraw Amount (Taka)">
                    </div>

                    <div class="row form-group ">
                        <label class="col-md-5">Transaction Date <span class="text-danger">*</span></label>
                        <input type="date" name="trans_date" id="trans_date" class="form-control col-md-7" max="{{ $today }}" placeholder="Transaction Date" required>
                    </div>
                    <div class="row form-group ">
                        <label class="col-md-5">Note</label>
                        <textarea type="text" rows="5" name="note" id="note" class="form-control col-md-7" placeholder="Note"></textarea>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="updateWithdrawBtn">Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->


<script type="text/javascript">
    function getDataA(WithdrawID) {
        // console.log(subMenu_id);
        $.ajax({
            url: "findWithdrawID", // path to function
            method: "GET",
            data: {

                WithdrawID: WithdrawID
            },
            dataType: "JSON",

            success: function(res) {

                // console.log(res.payMethodName);
                $("#transactionID").val(res.transactionID);
                $("#withDId").val(res.id);
                $("#withdraw_amounts").val(res.withdraw_amount);
                $("#exchange_rates").val(res.exchange_rate);
                $("#bdt_amounts").val(res.bdt_amount);
                $("#trans_date").val(res.trans_date);
                $("#note").text(res.note);

                if(res.payMethodName != null)
                {
                    $("#payMethodName").text(res.payMethodName);
                }else{
                    $("#payMethodName").text('N/A');
                }
                if(res.from_account != null)
                {
                    $("#to_account").val(res.from_account);
                }else{
                    $("#to_account").val('N/A');
                }
            },
        });
    }
</script>



{{-- Edit Withdraw Total amount check with current balance --}}
<script type="text/javascript">
    $(document).ready(function () {
        $(document).on('keyup change','#withdraw_amounts, #exchange_rates, #bdt_amounts ',function(){
            var accountsTotal = parseFloat($('#accountsTotal').val());
            var withdraw_amounts = parseFloat($('#withdraw_amounts').val());
            var exchange_rates = parseFloat($('#exchange_rates').val());

            console.log(exchange_rates);

            var bdt_amounts = parseFloat(withdraw_amounts * exchange_rates).toFixed(4);

            if( withdraw_amounts > accountsTotal ) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'You can not Give more than Accounts Total Amount !!!',
                });

                $('#withdraw_amounts').val(0.0);
                $('#exchange_rates').val(0.0);
                $('#bdt_amounts').val(0.0);
            }else{
                $('#bdt_amounts').val(bdt_amounts);
            }
        });
    });

</script>
