<?php
    use Illuminate\Support\Carbon;
    $currentDate = Carbon::now();
    $date = strtotime($currentDate);
    $today = date('Y-m-d', $date);
    // echo $today;
?>
<?php
    $findRole = DB::table('admin_role')->where('url', 'pay-to')->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>

@extends('admin.masterBlade')

@section('title')
    Subscription Details
@endsection

@section('content')
    @if($findRole != null )

        <section class="content" style="padding-top: 10px;">
            <div class="container-fluid">
                <div class="row">
                <div class="col-12">
                    <!-- Main content -->
                    <div class="invoice p-3 mb-3">
                    <!-- title row -->


                    <div class="ribbon-wrapper ribbon-xl">
                        <div class="ribbon bg-success text-lg">
                        Paid
                        </div>
                    </div>

                    <div class="row invoice-info">
                        <div class="col-sm-3 invoice-col">
                            <address>
                                {{-- <a href="#"><img src="" width="100" height="50" alt="Company Image"  style=""></a><br> --}}
                                <strong>Operator: {{ $findSub->operator->name }}</strong><br>
                                <b>Subscription Type:</b> {{ $findSub->subsType->name }} <br>
                                <b>Amount:</b> {{ $findSub->amount }}<br>
                            </address>
                        </div>
                        <!-- /.col -->
                        <div class="col-sm-3 invoice-col">
                            <address>
                                <b>Billing Date:</b> {{ $findSub->billing_date }}<br>
                                <b>Alert Date:</b> {{ $findSub->alert_date }}<br>
                                <b>Alert Status:</b>
                                    @if($findSub->alert_status == 1 )
                                        <span class="badge badge-success">Active</span>
                                    @else
                                        <span class="badge badge-danger">Inactive</span>
                                    @endif
                                <br>
                            </address>
                        </div>
                        <div class="col-sm-5 invoice-col">
                            <address>
                                <?php
                                    $currentDate = Carbon::now();
                                    $date = strtotime($currentDate);
                                    $today = date('d-m-Y, h:m:s A', $date);
                                ?>
                                {{-- <b>Print Date:</b> {{ $today }}<br> --}}
                                <b>Note:</b> {{ $findSub->note }}<br>
                            </address>
                        </div>
                    </div>
                    <!-- /.row -->

                    <div class="row" style="padding-top: 30px;">
                        <div class="col-12 table-responsive">
                            <h4>Paid Transaction</h4>
                            <table id="example1" class="table table-dotted">
                                <thead>
                                    <tr>
                                        <th width="2%">SL</th>
                                        <th width="10%">Operator</th>
                                        <th width="10%">Paid To</th>
                                        <th width="6%">Amount</th>
                                        <th width="10%">Billing Month</th>
                                        <th width="10%">Payment Method</th>
                                        <th width="9%">Transaction ID</th>
                                        <th width="10%">Transaction Date</th>
                                        <th width="10%">System Date</th>
                                        {{-- <th width="14%">Note</th> --}}
                                        <th width="9%">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($findSubPaymment as $key=>$SubPaymment)
                                        <tr>
                                            <td>{{$key+1}}</td>
                                            <td>{{ $SubPaymment->operator->name }} </td>
                                            <td>{{ $SubPaymment->receiver_name }} </td>
                                            <td>{{ $SubPaymment->amount }}</td>
                                            <td>
                                                @if($SubPaymment->billing_month != null)
                                                    {{ date('F', strtotime($SubPaymment->billing_month)) }}
                                                @else
                                                    N/A
                                                @endif
                                            </td>
                                            <td>{{ $SubPaymment->payMethod->name }}</td>
                                            <td>{{ $SubPaymment->transactionID }}</td>
                                            <td>{{ $SubPaymment->trans_date }}</td>
                                            <td>{{ $SubPaymment->created_at }}</td>
                                            {{-- <td>{{ $SubPaymment->note }}</td> --}}
                                            <td>
                                                <div class="btn-group">
                                                    <button type="button" class="btn btn-info">Action</button>
                                                    <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                        data-toggle="dropdown">
                                                        <span class="sr-only">Toggle Dropdown</span>
                                                    </button>
                                                    <div class="dropdown-menu dropdown-content" role="menu">
                                                        @if(Auth::user()->role == 1 || Auth::user()->role == 2)
                                                            <a class="dropdown-item" data-toggle="modal" data-target="#modal-default-edit"
                                                                onclick="getSubPaymmentData('<?php echo $SubPaymment->id ?>')" href="#">
                                                                <i class="fas fa-edit" style="padding-right:10px;"></i> Edit</a>
                                                        @endif
                                                        @if(Auth::user()->role == 1)
                                                            <a class="dropdown-item" href="{{url('destroy-sub-paymment-'.$SubPaymment->id)}}" id="delete">
                                                                <i class="fas fa-trash" style="padding-right:10px; "></i> Delete</a>
                                                        @endif
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- this row will not appear when printing -->
                    <div class="row no-print">
                        <div class="col-12">
                            <a href="#" onClick="window.print();" target="_blank" rel="noopener" class="btn btn-default"><i class="fas fa-print"></i> Print</a>
                        </div>
                    </div>
                    </div>
                    <!-- /.invoice -->
                </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </section>

        <!-- /Subscription Payment Update Modal Start -->
        <div class="modal fade" id="modal-default-edit">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Subscription Payment Update</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <form action="{{url('update-subscriptions-payments')}}" enctype="multipart/form-data" method="post">
                        @csrf
                        <div class="modal-body">

                            <div class="form-group">
                                <div class="row form-group">
                                    <label class="col-md-4">Paid To <span class="text-danger">*</span></label>
                                    <input type="text" id="receiver_name" name="receiver_name" class="form-control col-md-8" placeholder="Receiver Name" required>
                                </div>

                                <div class="row form-group ">
                                    <label class="col-md-4">Payment Method <span class="text-danger">*</span></label>
                                    <select class="col-md-8 form-control select" name="payment_method_id" style="width: 66.667%" required>
                                        <option id="payMethod" selected="" >Select Payment Method</option>
                                        @foreach($findPaymentMethods as $payNow)
                                            <option value="{{ $payNow->id }}">{{ $payNow->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="row form-group">
                                    <label class="col-md-4">Billing Month <span class="text-danger">*</span></label>
                                    <input type="date" id="billing_month" name="billing_month" class="form-control col-md-8" required placeholder="Billing Month">
                                </div>
                                <div class="row form-group">
                                    <label class="col-md-4">Amount <span class="text-danger">*</span></label>
                                    <input type="number" id="amunt" name="amount" min="0" step="0.0001" class="form-control col-md-8" placeholder="Amount" required>
                                </div>
                                <div class="row form-group">
                                    <label class="col-md-4">Transaction ID </label>
                                    <input type="text" id="trans_number" name="trans_number" class="form-control col-md-8" placeholder="Transaction ID Number">
                                </div>
                                <div class="row form-group">
                                    <label class="col-md-4">Transaction Date <span class="text-danger">*</span></label>
                                    <input type="date" id="trans_date" name="trans_date" class="form-control col-md-8" max="{{ $today }}" required placeholder="Transaction Date">
                                </div>
                                <div class="row form-group ">
                                    <label class="col-md-4">Note</label>
                                    <textarea type="text" id="note" rows="5" name="note" class="form-control col-md-8" placeholder="Note"></textarea>
                                </div>

                                <input type="hidden" id="subPayID" name="subPayID">
                                <input type="hidden" id="subscription_id" name="subscription_id">
                                <input type="hidden" id="subscription_type_id" name="subscription_type_id">

                                <input type="hidden" id="accountsTotal" value="{{ $accountsTotal->total }}">
                            </div>

                            <div class="modal-footer justify-content-between">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        </div>
                    </form>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
        <!-- /Subscription Payment Update Modal End -->

        <script type="text/javascript">
            function getSubPaymmentData(subsPayId) {
                // console.log(subsId);
                $.ajax({
                    url: "findSubscriptionPaymentID", // path to function
                    method: "GET",
                    data: {
                        subsPayId: subsPayId
                    },
                    dataType: "JSON",
                    success: function(res) {
                        // console.log(res.subscription_type_id);
                        $("#receiver_name").val(res.receiver_name);
                        $("#payMethod").text(res.payMethod);
                        $("#billing_month").val(res.billing_month);
                        $("#amunt").val(res.amount);
                        $("#trans_number").val(res.trans_number);
                        $("#trans_date").val(res.trans_date);
                        $("#note").val(res.note);

                        $("#subPayID").val(res.id);
                        $("#subscription_id").val(res.subscription_id);
                        $("#payment_method_id").val(res.payment_method_id);
                        $("#subscription_type_id").val(res.subscription_type_id);
                    },
                });
            }
        </script>



        {{-- Update Pay Now amount validation from subscription details --}}
        <script type="text/javascript">
            $(document).ready(function () {
                $(document).on('keyup change','#amunt',function(){
                    var accountsTotal = parseFloat($('#accountsTotal').val());
                    var amunt = parseFloat($('#amunt').val());

                    console.log(accountsTotal);

                    if( amunt > accountsTotal ) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'You can not Give more than Accounts Total Amount !!!',
                        });

                        $('#amunt').val(0.0);
                    }else{
                        $('#amunt').val(amunt);
                    }
                });
            });

        </script>

    @else
        @include('admin.404')
    @endif
@endsection

