<?php
    use Illuminate\Support\Carbon;
    $currentDate = Carbon::now();
    $date = strtotime($currentDate);
    $today = date('Y-m-d', $date);
    // echo $today;  strtotime(date('Y-m-d', $currentDate));
?>
<?php
    $currentURLs = URL::current(); // current url with domain name
    $currentURL = request()->path(); // current url without domain name
    // dd($currentURL);
    $findRole = DB::table('admin_role')->where('url', $currentURL)->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>

@extends('admin.masterBlade')

@section('title')
Budget Request
@endsection

@section('content')

@if($findRole->url == $currentURL )

<section class="content">
    <div class="container-fluid">
        <div class="row" style="margin-top:10px;">
            <div class="col-md-12 col-sm-6">
                <div class="card card-success card-tabs">
                    <div class="card-header p-0 pt-1">
                        <ul class="nav flex-row nav-tabs nav-tabs-right" id="custom-tabs-one-tab" role="tablist">
                            <li class="nav-item ">
                                <a class="nav-link active" id="custom-tabs-one-profile-tab" data-toggle="pill"
                                    href="#order-pending" role="tab" aria-controls="custom-tabs-one-profile"
                                    aria-selected="false">Pending Budget</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="custom-tabs-one-messages-tab" data-toggle="pill"
                                    href="#order-accept" role="tab" aria-controls="custom-tabs-one-messages"
                                    aria-selected="false">Accept Budget</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="custom-tabs-one-messages-tab" data-toggle="pill"
                                    href="#order-decline" role="tab" aria-controls="custom-tabs-one-messages"
                                    aria-selected="false">Declined Budget</a>
                            </li>

                        </ul>
                    </div>
                    <div class="card-body">
                        <div class="tab-content" id="custom-tabs-one-tabContent">
                            <div class="tab-pane fade show active" id="order-pending" role="tabpanel"
                                aria-labelledby="custom-tabs-one-home-tab">
                                @include('admin.page.accounts.administration.budgetReceived.vendor.pendingBudgetReceived')
                            </div>
                            <div class="tab-pane fade" id="order-accept" role="tabpanel"
                                aria-labelledby="custom-tabs-one-profile-tab">
                                @include('admin.page.accounts.administration.budgetReceived.vendor.budgetReceived')
                            </div>
                            <div class="tab-pane fade" id="order-decline" role="tabpanel"
                                aria-labelledby="custom-tabs-one-messages-tab">
                                @include('admin.page.accounts.administration.budgetReceived.vendor.declinedBudgetReceived')
                            </div>

                        </div>
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </div>
</section>


    <!-- /Edit budget Modal Start -->
    <div class="modal fade" id="edit-budget">
        @include('admin.page.accounts.vendor.budgetReceived.editbudget')
    </div>
    <!-- /Edit budget Modal End -->
    

@else
@include('admin.404')
@endif
<script>
    $("#createBudgetReceiveBtn").click(function () {
        $(this).attr("disabled", "disabled");
        $('#createBudgetReceiveForm').submit();
        setTimeout('$("#createBudgetReceiveBtn").removeAttr("disabled")', 1500);
    });
    $("#updateBudgetReceiveBtn").click(function () {
        $(this).attr("disabled", "disabled");
        $('#updateBudgetReceiveForm').submit();
        setTimeout('$("#updateBudgetReceiveBtn").removeAttr("disabled")', 1500);
    });
</script>
@endsection
