<?php use Illuminate\Support\Carbon; ?>

<?php
    // Notification
    $startDate = Carbon::now(); //returns current day
    $firstDayOfMonth = $startDate->firstOfMonth()->format('Y-m-d');
    $lastDayOfMonth = $startDate->lastOfMonth()->format('Y-m-d');

    $findSubs = App\Models\Subscription::whereIn('status', [1,2])->orderBy('billing_date', 'ASC')->limit(10)->get();
    
    
    $currentMonth = Carbon::now()->month;
    $currentYear = Carbon::now()->year;
    $countAlert = 0;
    foreach($findSubs as $key=> $data){
        $cAlert = App\Models\SubscriptionPayment::where('subscription_id', $data->id)
                    ->whereMonth('created_at', $currentMonth)
                    ->whereYear('created_at', $currentYear)
                    ->count();
        $countAlert = $countAlert + 1 - $cAlert;
        
        
        // echo $cAlert;
        // echo nl2br("(cAletr) \n ");
        // echo $countAlert;
        // echo nl2br("(countAlert)\n");
    }

    // dd($cAlert);

    $isDarkMode = auth()->user()->is_dark_mode;

?>

<script src="{{ asset('admin_assets/plugins/jquery/jquery.min.js') }}"></script>


<nav class="main-header navbar navbar-expand navbar-white">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
        </li>
        <li class="nav-item" id="clockDecoration">
            <a class="nav-link" href="#" role="button">
                <strong class="clockDecoration"> <i id="clock"></i></strong>
            </a>
        </li>
    </ul>

    <ul class="navbar-nav" style="" id="authName">
        <li class="nav-item">
            <a class="nav-link d-block welcome" href="#" role="button">Welcome! {{ Auth::user()->name }}</a>
        </li>
    </ul>

    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">

        @if (Auth::user()->role == 1 || Auth::user()->role == 2)
            <li class="nav-item dropdown">
                <a class="nav-link" data-toggle="dropdown" href="#">
                    <i class="far fa-bell"></i>
                    <span class="badge badge-warning navbar-badge">{{ $countAlert }}</span>
                </a>

                @if(!empty($countAlert))
                    <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">


                        <span class="dropdown-item dropdown-header">{{ $countAlert }} Subscription Alert</span>
                        @foreach($findSubs as $data)
                            <?php
                                $findAlert = App\Models\SubscriptionPayment::where('subscription_id', $data->id)
                                            ->whereMonth('created_at', Carbon::now()->month)
                                            ->whereYear('created_at', $currentYear)
                                            ->first();
                            ?>
                            @if(empty($findAlert))
                                <div class="dropdown-divider"></div>
                                <a href="{{ ('subscription-details-'.$data->id) }}" class="dropdown-item" style="white-space:normal">
                                    <i class="far fa-bell"></i> <b>{{ $data->subsType->name }}</b> Last Date
                                    <span style="color:red; font-weight: bold;">{{ date('d', strtotime($data->billing_date)) }}, {{ date('F', strtotime(Carbon::now())) }}</span>

                                </a>
                            @endif
                        @endforeach

                        <a href="{{ url('pay-to') }}" target="_blank" class="dropdown-item dropdown-footer">See All Alert</a>
                    </div>
                @endif
            </li>
        @endif


        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="fas fa-user-cog"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-md dropdown-menu-right">
                <a href="{{ url('profile') }}" class="dropdown-item">
                    <!-- Message Start -->
                    <div class="media">
                        <i class="fas fa-user-circle img-size-40 mr-2 img-circle"></i>
                        <div class="media-body">
                            <h3 class="dropdown-item-title">
                                Profile
                            </h3>
                        </div>
                    </div>
                    <!-- Message End -->
                </a>
                <a class="dropdown-item" href="{{ route('logout') }}" onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();"
                    class="dropdown-item">
                    <!-- Message Start -->
                    <div class="media">
                        <i class="fas fa-sign-in-alt img-size-40 mr-2 img-circle"></i>
                        <div class="media-body">
                            <h3 class="dropdown-item-title">
                                Logout
                            </h3>
                        </div>
                    </div>
                    <!-- Message End -->
                </a>

                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                    @csrf
                </form>

                {{-- <label class="btn btn-white">
                    <input type="radio" name="options" id="option_a1" autocomplete="off" checked><i style="size:5x;" class="fas fa-sun"></i>
                </label>
                <label class="btn btn-white">
                    <input type="radio" name="options" id="option_a2" autocomplete="off"> <i class="far fa-moon"></i>
                </label> --}}
            </div>
        </li>


        <li class="nav-item">
            <a class="nav-link" data-widget="fullscreen" href="#" role="button">
                <i class="fas fa-expand-arrows-alt"></i>
            </a>
        </li>

        <li class="nav-item">
            <div class="btn-group btn-group-toggle" data-toggle="buttons">
                <label class="btn btn-white">
                    <input type="radio" name="options" value="0" id="option_a1" autocomplete="off" checked>
                    <i style="size:5x;" class="fas fa-sun"></i>
                </label>
                <label class="btn btn-white">
                    <input type="radio" name="options" value="1" id="option_a2" autocomplete="off">
                    <i class="far fa-moon"></i>
                </label>

            </div>
        </li>
    </ul>
</nav>

<script>
    function currentTime() {
        var date = new Date(); /* creating object of Date class */
        var hour = date.getHours();
        var min = date.getMinutes();
        var sec = date.getSeconds();
        var midday = "AM";
        midday = (hour >= 12) ? "PM" : "AM"; /* assigning AM/PM */
        hour = (hour == 0) ? 12 : ((hour > 12) ? (hour - 12) : hour); /* assigning hour in 12-hour format */
        hour = updateTime(hour);
        min = updateTime(min);
        sec = updateTime(sec);
        document.getElementById("clock").innerText = hour + " : " + min + " : " + sec + " " +
        midday; /* adding time to the div */
        var t = setTimeout(currentTime, 1000); /* setting timer */
    }

    function updateTime(k) {
        /* appending 0 before time elements if less than 10 */
        if (k < 10) {
            return "0" + k;
        } else {
            return k;
        }
    }
    currentTime();
    // Clock implement from this link: https://www.codesdope.com/blog/article/how-to-create-a-digital-clock-using-javascript/
</script>

<script>

    var is_dark = '';

    $('#option_a1').on('click', function() {
        if ($(this).is(':checked')) {
            $('body').removeClass('dark-mode')
            $('nav').removeClass('dark-mode')
        } else {
            $('body').addClass('dark-mode')
            $('nav').addClass('dark-mode')
        }

        is_dark = $('input[name="options"]:checked').val();

        isDarkMode(is_dark);
    })

    $('#option_a2').on('click', function() {
        if ($(this).is(':checked')) {
            $('body').addClass('dark-mode')
            $('nav').addClass('dark-mode')
        } else {
            $('body').removeClass('dark-mode')
            $('nav').removeClass('dark-mode')
        }

        is_dark = $('input[name="options"]:checked').val();

        isDarkMode(is_dark);
    })

    function isDarkMode(is_dark) {

        if (is_dark) {
            $.ajax({
                url: "is-dark-mode", // path to function
                method: "GET",
                data: {
                    is_dark: is_dark
                },
                dataType: "JSON",

                success:function (res) {

                    if (is_dark == 1) {
                        $('body').addClass('dark-mode')
                        $('nav').addClass('dark-mode')
                    } else {
                        $('body').removeClass('dark-mode')
                        $('nav').removeClass('dark-mode')
                    }
                    location.reload();
                }
            })
        }

    }


    $( document ).ready(function() {

        var is_dark = <?php echo json_encode($isDarkMode); ?>;

        if (is_dark == 1) {
            $('body').addClass('dark-mode')
            $('nav').addClass('dark-mode')
        } else {
            $('body').removeClass('dark-mode')
            $('nav').removeClass('dark-mode')
        }

    });
</script>
