@if( Auth::user()->role == 1 || Auth::user()->role == 2)
    @extends('admin.masterBlade')

    @section('title')
        USER ACCESS
    @endsection
    @section('content')

        <div class="row" style="padding: 20px;">
            <div class="col-md-8">
                <!-- general form elements -->
                <div class="card card-navy  color-palette">
                    <div class="card-header">
                        <h3 class="card-title">User Access</h3>
                    </div>
                    <form action="{{route('insert_menu_accessList')}}?>" method="POST" class="form-horizontal" role="form">
                        @csrf
                        <div class="card card-primary card-outline">
                            <div class="card-body">
                                <div class="form-group row">
                                    <div class="col-sm-12">
                                        <select class="form-control" name="user_id" id="user_id">
                                            <option selected="" disabled="">Select User</option>
                                            @foreach($userlist as $each)
                                            <option value="{{$each->id}}">{{$each->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card card-primary card-outline" >
                            <div class="card-body">
                                <div class="col-sm-12" >
                                    <div id="new_data"></div>
                                </div>

                            </div>
                            <!-- /.row -->
                        </div><!-- /.container-fluid -->
                    </form>
                </div>
            </div>
        </div>

        @section('script')
        <script>
            $(document).ready(function() {
                $('#user_id').change(function() {
                    var user_id = $('#user_id').val();
                    console.log(user_id);
                    $.ajax({
                        type: "post",
                        url: "/get_menu_list", // path to function
                        cache: false,

                        data: {
                            "_token": "{{ csrf_token() }}",
                            user_id: user_id
                        },
                        success: function(val) {


                            $("#new_data").html(val);

                        }
                    });
                });
            });
        </script>
        @endsection

    @endsection

@else
    @include('admin.404')
@endif
