@extends('admin.masterBlade')

@section('title')
    Manage Role
@endsection

@section('content')

@if(Auth::user()->role == 1)
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-success table-responsive" style="margin-top:20px;">

                        <div class="card-header text-center">
                            <h5 class="m-0 text-white">Employee Role List
                                <a href="{{url('user-access')}}">
                                    <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px; padding-right:20px"></i>
                                </a>
                            </h5>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">

                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Name</th>
                                        <th>email</th>
                                        <th>Phone</th>
                                        <th>Role</th>
                                        <th>Manage Role</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($getEmployee as $key => $getData)
                                    <tr>
                                        <td>{{ ++$key }}</td>
                                        <td>{{ $getData->name }}</td>
                                        <td>{{ $getData->email }}</td>
                                        <td>{{ $getData->phone }}</td>
                                        <td>
                                            @if($getData->role == 2)
                                                <span class="textSize badge badge-success">Admin</span>
                                            @elseif($getData->role == 5)
                                                <span class="textSize badge badge-info">Supervisor</span>
                                            @elseif($getData->role == 6)
                                                <span class="textSize badge badge-primary">Employee</span>
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-info  dropdown-icon" data-toggle="dropdown" style="border-radius: 4px 4px">
                                                    Action
                                                    <i class="dropdown-toggle" style=""></i>
                                                    <span class="sr-only">Toggle Dropdown</span>
                                                </button>
                                                <div class="dropdown-menu dropdown-content" role="menu" >
                                                    @if(Auth::user()->role == 1)
                                                        @if($getData->role == 2)
                                                            <form action="{{ route('update-role') }}" method="post">
                                                                @csrf
                                                                <input type="hidden" name="role" value="5">
                                                                <input type="hidden" name="id" value="{{ $getData->id }}">
                                                                <a class="dropdown-item" href="#">
                                                                    <button type="submit" class="btn">
                                                                        <span class="fas fa-user-cog" style="padding-right:10px;"></span>Supvisor
                                                                    </button>
                                                                </a>
                                                            </form>

                                                            <form action="{{ route('update-role') }}" method="post">
                                                                @csrf
                                                                <input type="hidden" name="role" value="6">
                                                                <input type="hidden" name="id" value="{{ $getData->id }}">
                                                                <a class="dropdown-item" href="#">
                                                                    <button type="submit" class="btn">
                                                                        <span class="fas fa-users" style="padding-right:10px;"></span>Employee
                                                                    </button>
                                                                </a>
                                                            </form>

                                                        @elseif($getData->role == 5)
                                                            <form action="{{ route('update-role') }}" method="post">
                                                                @csrf
                                                                <input type="hidden" name="role" value="2">
                                                                <input type="hidden" name="id" value="{{ $getData->id }}">
                                                                <a class="dropdown-item" href="#">
                                                                    <button type="submit" class="btn">
                                                                        <span class="fas fa-user-shield" style="padding-right:10px;"></span>Admin
                                                                    </button>
                                                                </a>
                                                            </form>

                                                            <form action="{{ route('update-role') }}" method="post">
                                                                @csrf
                                                                <input type="hidden" name="role" value="6">
                                                                <input type="hidden" name="id" value="{{ $getData->id }}">
                                                                <a class="dropdown-item" href="#">
                                                                    <button type="submit" class="btn">
                                                                        <span class="fas fa-users" style="padding-right:10px;"></span>Employee
                                                                    </button>
                                                                </a>
                                                            </form>

                                                        @elseif($getData->role == 6)
                                                            <form action="{{ route('update-role') }}" method="post">
                                                                @csrf
                                                                <input type="hidden" name="role" value="2">
                                                                <input type="hidden" name="id" value="{{ $getData->id }}">
                                                                <a class="dropdown-item" href="#">
                                                                    <button type="submit" class="btn">
                                                                        <span class="fas fa-user-shield" style="padding-right:10px;"></span>Admin
                                                                    </button>
                                                                </a>
                                                            </form>

                                                            <form action="{{ route('update-role') }}" method="post">
                                                                @csrf
                                                                <input type="hidden" name="role" value="5">
                                                                <input type="hidden" name="id" value="{{ $getData->id }}">
                                                                <a class="dropdown-item" href="#">
                                                                    <button type="submit" class="btn">
                                                                        <span class="fas fa-user-cog" style="padding-right:10px;"></span>Supervisor
                                                                    </button>
                                                                </a>
                                                            </form>

                                                        @else
                                                            <a class="dropdown-item" href="#">
                                                                <span class="" style="padding-right:10px;"></span> N/A
                                                            </a>
                                                        @endif
                                                    @endif
                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

    @else
        @include('admin.404')
    @endif

@endsection
