<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vendor_payments', function (Blueprint $table) {
            $table->id();

            $table->integer('vendor_id')->nullable()->comment('user.id = vendor_id');
            $table->integer('assign_id')->nullable()->comment('assign_tables.id = assign_id');
            $table->integer('order_id')->nullable()->comment('orders.id = order_id');
            $table->integer('payment_from')->nullable();
            $table->integer('payment_method_id')->nullable()->comment('payment_methods.id = payment_method_id');
            $table->float('amount',8,2)->nullable();
            $table->float('pay', 8,2)->nullable();
            $table->float('due', 8,2)->nullable();
            $table->date('trans_date')->nullable();
            $table->longText('note')->nullable();
            $table->integer('status')->nullable()->comment('0 = delete, 1 = insert, 2 = update');

            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('updated_by')->nullable();
            $table->date('updated_date')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->date('deleted_date')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vendor_payments');
    }
};
