<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();

            $table->integer('trans_type')->nullable()->comment('1 = Budget Received, 2 = Payment To Vendor, 3 = Expenses, 4 = Salary, 5 = Due Received, 6 = Due Payment, 7 = Risk Payment, 8 = Advanced Payment, 9 = Refund, 10 = Withdraw, 11 = Subscription Payment, 12 = Spend Money for order from clients account');
            $table->float('amount',8,2)->nullable();
            $table->date('date')->nullable();
            $table->integer('employee_salaries_id')->nullable()->comment('employee_salaries.id');
            $table->integer('subscriptionID')->nullable()->comment('subscriptions.id');
            $table->integer('subsPaymentId')->nullable()->comment('subscription_payments.id');
            $table->integer('withdraw_id')->nullable()->comment('withdraws.id');
            $table->integer('budget_received_id')->nullable()->comment('budget_receiveds.id');
            $table->integer('spend_money_id')->nullable()->comment('spend_money.id');
            $table->integer('vendor_payments_id')->nullable()->comment('vendor_payments.id');
            $table->integer('client_refund_req_id')->nullable()->comment('client_refund_req.id');
            $table->integer('order_id')->nullable();
            $table->integer('vendor_id')->nullable();
            $table->integer('employee_id')->nullable();
            $table->integer('expense_id')->nullable();
            $table->longText('note')->nullable();
            $table->integer('status')->nullable()->comment('0 = delete, 1 = insert, 2 = update');

            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('updated_by')->nullable();
            $table->date('updated_date')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->date('deleted_date')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
};
