<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('address')->nullable();
            $table->string('contact')->nullable();
            $table->string('website')->nullable();
            $table->string('logo')->nullable();
            $table->string('favicon')->nullable();
            $table->string('tin')->nullable();
            $table->integer('status')->nullable()->comment('1=Insert, 2=Update, 0=Delete');

            $table->integer('created_by')->nullable()->comment('created_by = User.id');
            $table->dateTime('created_time')->nullable();
            $table->integer('updated_by')->nullable()->comment('updated_by = User.id');
            $table->dateTime('updated_time')->nullable();
            $table->integer('deleted_by')->nullable()->comment('deleted_by = User.id');
            $table->dateTime('deleted_time')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('company');
    }
};
