<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->integer('role')->nullable()->comment('1=system_admin, 2=admin, 3=client, 4=vendor, 5=Supervisor, 6=Employee');
            $table->string('name');
            $table->string('email')->unique();
            $table->string('phone')->nullable();
            $table->longText('address')->nullable();
            $table->integer('gender')->nullable()->comment('1=male, 2= female, 3=others');
            $table->date('dob')->nullable();
            $table->string('password');
            $table->string('image', 2048)->nullable();
            $table->string('pass_code')->nullable();
            $table->date('joining_date')->nullable();
            $table->string('nid')->nullable();
            $table->integer('salary',8,2)->nullable();

            $table->integer('status')->nullable()->comment('0=delete, 1= insert, 2= update, 3=active, 4=inactive');

            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('updated_by')->nullable();
            $table->date('updated_date')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->date('deleted_date')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->rememberToken();
            $table->foreignId('current_team_id')->nullable();
            $table->timestamps();
        });
    }


    public function down()
    {
        Schema::dropIfExists('users');
    }
};
