<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VendorPayment extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function operator(){
        return $this->belongsTo(User::class, 'created_by');
    }
    public function vendor(){
        return $this->belongsTo(User::class, 'vendor_id');
    }
    public function payMethod(){
        return $this->belongsTo(PaymentMethod::class, 'payment_method_id');
    }
    public function assign(){
        return $this->belongsTo(AssignTable::class, 'assign_id');
    }
    public function order(){
        return $this->belongsTo(Order::class, 'order_id');
    }
}
