<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VendorBudgetReceived extends Model
{
    use HasFactory;

    protected $fillable = [
        'payment_method_id',
        'received_amount',
        'charge',
        'charge_note',
        'current_balance',
        'trans_date',
        'note',
        'status',
        'created_by',
        'created_date',
        'updated_by',
        'updated_date',
        'deleted_by',
        'deleted_date',
        'trnx_id',
        'total_amount',
        'received_by'
    ];

    public function operator(){
        return $this->belongsTo(User::class, 'created_by');
    }

    public function clients(){
        return $this->belongsTo(User::class, 'client_id');
    }

    public function payMethod(){
        return $this->belongsTo(PaymentMethod::class, 'payment_method_id');
    }
}
