<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClientRefundRequest extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function operator(){
        return $this->belongsTo(User::class, 'created_by');
    }
    public function order()
    {
        return $this->belongsTo(Order::class, 'order_id');
    }
    public function service()
    {
        return $this->belongsTo(ServiceType::class, 'service_type_id');
    }

    public function payMethod(){
        return $this->belongsTo(PaymentMethod::class, 'payment_method_id');
    }
    public function client(){
        return $this->belongsTo(User::class, 'client_id');
    }
}
