<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderMail extends Mailable
{
    use Queueable, SerializesModels;

    public $findUserMail, $findOrder;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($findUserMail,$findOrder)
    {
        $this->findUserMail = $findUserMail;
        $this->findOrder = $findOrder;
    }

    public function build()
    {
        return $this->subject('Order Status')
                    ->view('emails.orderMail')->with('findUserMail', 'findOrder', $this->findUserMail, $this->findOrder );
    }
}
