<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CompleteOrderMail extends Mailable
{
    use Queueable, SerializesModels;

    public $getOrder, $getVendor;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($getOrder,$getVendor)
    {
        $this->getOrder = $getOrder;
        $this->getVendor = $getVendor;
    }

    public function build()
    {
        return $this->subject('Order Status')
                    ->view('emails.completeOrderMail')->with('getOrder', 'getVendor', $this->getOrder, $this->getVendor );
    }
}
