<?php

namespace App\Imports;

use App\Models\AssignTable;
use App\Models\WorksDetails;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsEmptyRows;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class WorksDetailsImport implements ToModel, WithHeadingRow, SkipsEmptyRows
{
    use Importable;

    protected $vandor_id;
    protected $order_id;
    protected $assign_id;
    protected $service_type_id;
    protected $uniqueId;

    function __construct($vandor_id, $order_id, $assign_id, $service_type_id, $uniqueId)
    {
        $this->vandor_id = $vandor_id;
        $this->order_id = $order_id;
        $this->assign_id = $assign_id;
        $this->service_type_id = $service_type_id;
        $this->uniqueId = $uniqueId;
        $this->i = 0;
    }

    public function model(array $row)
    {
        $countdata = count(WorksDetails::where('assign_id', $this->assign_id)->whereIn('status', [1, 2])->get());
        $assign = AssignTable::find($this->assign_id);

        if ($countdata < $assign->total_quantity) {
            $workCount = count(WorksDetails::where('assign_id', $this->assign_id)->where('status', '!=', 0)->get());
            $assign = AssignTable::find($this->assign_id);

            if ($workCount == $assign->total_quantity - 1) {
                AssignTable::where('id', $this->assign_id)->update([
                    'work_status' => 4,
                    'v_work_status' => 4,
                ]);
            }

            if ($this->service_type_id == 3) {
                abort_unless(isset($row['install_date']), 404);

                if (gettype($row['install_date']) == 'string') {
                    $date = date('Y-m-d', strtotime($row['install_date']));
                } else if (gettype($row['install_date']) == 'integer') {
                    $excelDate = $row['install_date'];
                    $miliseconds = ($excelDate - (25567 + 2)) * 86400 * 1000;
                    $seconds = $miliseconds / 1000;
                    $get = date("d-m-Y", $seconds);
                    $date = date('Y-m-d', strtotime($get));
                } else {
                    $date = $row['install_date']->format('Y-m-d');
                }

                return new WorksDetails([
                    'install_date'          => $date,
                    'keyword'               => $row['keyword'],
                    'country'               => $row['country'],
                    'country_code'          => $row['country_code'],
                    'os_version'            => $row['osversion'],
                    'idfa'                  => $row['idfa'],
                    'ip'                    => $row['ip'],
                    'vandor_id'             => $this->vandor_id,
                    'order_id'              => $this->order_id,
                    'assign_id'             => $this->assign_id,
                    'work_details_status'   => 1,
                    'status'                => 1,
                    'work_details_u_id'     => $this->uniqueId + $this->i++,
                    'service_type_id'       => $this->service_type_id,
                ]);
            } else {
                return new WorksDetails([
                    'reiew_discription'     => preg_replace('/_x([0-9a-fA-F]{4})_/', '', $row['review_text']),
                    'title'                 => $row['title'],
                    'ratting'               => $row['rating'],
                    'posting_status'        => $row['posting_status'],
                    'user_name'             => $row['user_name'],
                    'vandor_id'             => $this->vandor_id,
                    'order_id'              => $this->order_id,
                    'assign_id'             => $this->assign_id,
                    'work_details_status'   => 1,
                    'status'                => 1,
                    'work_details_u_id'     => $this->uniqueId + $this->i++,
                    'service_type_id'       => $this->service_type_id,
                ]);
            }
        }
    }

    public function headingRow(): int
    {
        return 2;
    }
}
