<?php

namespace App\Http\Controllers\websites;

use App\Models\Blog;
use App\Models\FootPrint;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class BlogController extends Controller
{
    public function index()
    {
        $blog = Blog::whereIn('status', [1, 2, 3])->orderBy('id', 'DESC')->get();
        return view('admin.page.manageWebsites.blog.index', get_defined_vars());
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title'         => 'required|string',
            'image_alt_name' => 'nullable|string',
            'description'   => 'required|string',
            'image'         => 'required|image|mimes:jpg,png,jpeg,gif,svg,webp|max:2048',
        ]);

        if ($validator->fails()) {
            $notification = array(
                'message'   => 'Please Check Error Message !!!',
                'alert-type' => 'error'
            );
            return back()->with($notification);
        } else {

            $data               = new Blog;
            $data->title        = $request->title;
            $data->image_alt_name = $request->image_alt_name;
            $data->description  = $request->description;

            if ($request->file('image')) {
                $file = $request->file('image');
                $filename = date('YmdHi') . $file->getClientOriginalName();
                $file->move(public_path('upload/blog'), $filename);
                $data['image'] = $filename;
            }
            $data->status       = 1;
            $data->created_by   = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->save();

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name  = 'blogs';
            $fData->table_id    = $data->id;
            $fData->comment     = "Blog added";
            $fData->status      = 1;
            $fData->save();

            $notification = array(
                'message'   => 'Blog Added Successfully',
                'alert-type' => 'success'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function editBlog(Request $request, Blog $blog)
    {
        return view('admin.page.manageWebsites.blog.update', get_defined_vars());
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title'         => 'required|string',
            'image_alt_name' => 'required|string',
            'description'   => 'required|string',
            'image'         => 'nullable|image|mimes:jpg,png,jpeg,gif,svg,webp|max:2048'
        ]);

        if ($validator->fails()) {
            $notification = array(
                'message'   => 'Opps!!! Please check error message',
                'alert-type' => 'error'
            );
            return back()->with($notification);
        } else {
            $data               = Blog::find($request->id);
            $data->title        = $request->title;
            $data->image_alt_name = $request->image_alt_name;
            $data->description  = $request->description;
            $data->updated_by   = Auth::user()->id;
            $data->updated_date = Carbon::now();
            $data->status       = 2;
            if ($request->file('image')) {
                @unlink(public_path('upload/blog/' . $data->image));
                $file = $request->file('image');
                $filename = date('YmdHi') . $file->getClientOriginalName();
                $file->move(public_path('upload/blog'), $filename);
                $data['image'] = $filename;
            }
            $data->save();

            if ($data->id != null) {
                $fData              = new FootPrint();
                $fData->operator_id = Auth::user()->id;
                $fData->table_name  = 'blogs';
                $fData->table_id    = $request->id;
                $fData->comment     = "blog updated";
                $fData->status      = 2;
                $fData->save();

                $notification = array(
                    'message'   => 'Blog Updated successfully',
                    'alert-type' => 'success'
                );
            } else {
                $notification = array(
                    'message'   => 'Somethings is wrong !!',
                    'alert-type' => 'error'
                );
            }
            return redirect()->route('blog.list')->with($notification);
        }
    }

    public function destroy(Blog $blog)
    {
        $blog->delete();
        $notification = array(
            'message'   => 'Blog Deleted Successfully !!',
            'alert-type' => 'success'
        );
        return back()->with($notification);
    }

    public function detailsBlog(Blog $blog)
    {
        return view('admin.page.manageWebsites.blog.details', get_defined_vars());
    }
}
