<?php

namespace App\Http\Controllers\vendor;

use App\Models\User;
use App\Models\AssignTable;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\VendorAccount;

class VendorProfileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {
        $findUser = User::where('id',$id)->where('role', 4)->first();
        if($findUser != null ){
            $findVendor = User::where('id', $id)->first();
            $totalEarn = AssignTable::where('ven_Emp_id', $id)->whereIn('status',[1,2,3])->sum('total_earn');
            $totalDue = AssignTable::where('ven_Emp_id', $id)->whereIn('status',[1,2,3])->sum('total_due');
            $totalReceived = AssignTable::where('ven_Emp_id', $id)->whereIn('status', [1,2])->sum('total_pay');

            $totalOrder = AssignTable::where('ven_Emp_id', $id)
                            ->whereIn('status', [1,2,3])
                            ->whereIn('work_status', [2,3,4,5,6,7,9,10])
                            ->count('id');

            $completeOrder = AssignTable::where('ven_Emp_id', $id)
                        ->whereIn('status', [1,2,3])
                        ->where('work_status', 10)
                        ->count('id');

            $currentOrder = AssignTable::where('ven_Emp_id', $id)
                        ->whereIn('status', [1,2,3])
                        ->whereIn('work_status', [2, 3, 4, 5, 6, 9])
                        ->count('id');


            $total = DB::select('SELECT COUNT(works_details.id) as total, works_details.order_id as o_id FROM works_details WHERE `status` !=0 GROUP BY works_details.order_id');
            // dd($currentOrder);
            $findAsignOrder = AssignTable::where('ven_Emp_id', $id)
                            ->whereIn('status', [1,2,3])
                            ->whereIn('work_status', [2,3,4,5,6,7,9])
                            ->get();

            $vendor_account = VendorAccount::where('balance_holder',$id)->first();
            
            return view('admin.index.vendorDashboard.vendorDashboard', get_defined_vars());
        }else{
            return view('admin.404');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
