<?php

namespace App\Http\Controllers\vendor;

use App\Models\Order;
use App\Models\FootPrint;
use App\Models\AssignTable;
use App\Models\WorksDetails;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use App\Imports\WorksDetailsImport;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Validator;

class VendorOrderController extends Controller
{

    public function pendingOrder()
    {
        $datas =  DB::table('assign_tables')
            ->join('orders', 'assign_tables.order_id', '=', 'orders.id')
            ->join('service_types', 'assign_tables.service_type_id', '=', 'service_types.id')
            ->select(
                'assign_tables.*',
                'orders.apps_link',
                'orders.file',
                'orders.platform',
                'orders.perday',
                'orders.geo',
                'orders.order_unique_id',
                'orders.key_word',
                'orders.comment',
                'service_types.name'
            )
            ->where('assign_tables.status', [1, 2, 3])
            ->whereIn('assign_tables.v_work_status', [1])
            ->where('ven_Emp_id', Auth::user()->id)
            ->get();

        //$workers = User::whereIn('status',[1,2,3])->whereIn('role',[4,6])->get();
        //dd($datas);
        return view('vendor.order.pendingOrder', get_defined_vars());
    }

    public function AcceptOrder($id)
    {
        $get = AssignTable::find($id);

        AssignTable::where('id', $id)->update([
            'work_status' => 3,
            'total_due' => $get->total_service_cost,
            'v_work_status' => 3,
            'updated_by' => Auth()->user()->id,
        ]);

        Order::where('id', $get->order_id)->update([
            'order_status' => 3,
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->assign_id = $id;
        $fData->comment = "Accept pending Order";
        $fData->status = 8;
        $fData->save();
        $notification = array(
            'message' => 'Accept pending Order Successfully',
            'alert-type' => 'success'
        );
        return Redirect()->back()->with($notification);
    }

    public function holdList()
    {
        $datas =  DB::table('assign_tables')
            ->join('orders', 'assign_tables.order_id', '=', 'orders.id')
            ->join('service_types', 'assign_tables.service_type_id', '=', 'service_types.id')
            ->select(
                'assign_tables.*',
                'orders.apps_link',
                'orders.file',
                'orders.platform',
                'orders.perday',
                'orders.geo',
                'orders.order_unique_id',
                'orders.key_word',
                'orders.comment',
                'service_types.name'
            )
            ->where('assign_tables.status', [1, 2, 3])
            ->where('assign_tables.work_status', 7)
            ->where('ven_Emp_id', Auth::user()->id)
            ->orderby('id', 'desc')
            ->get();
        //dd($datas);
        $dataCount = DB::select('SELECT COUNT(*) AS total, works_details.assign_id id FROM works_details WHERE vandor_id = ? and status !=0 GROUP BY assign_id  ', [Auth::user()->id]);
        //dd($datas);
        return view('vendor.order.inProgress', get_defined_vars());
    }

    public function DeclineOrder($id)
    {
        $get = AssignTable::find($id);

        $oData = Order::find($get->order_id);
        $oData->assigned_quantity = $oData->assigned_quantity - $get->total_quantity;
        $oData->available_quantity = $oData->available_quantity + $get->total_quantity;
        $oData->save();

        AssignTable::where('id', $id)->update([
            'work_status' => 8,
            'v_work_status' => 8,
            'updated_by' => Auth()->user()->id,
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->assign_id = $id;
        $fData->comment = "Reject Order";
        $fData->status = 9;
        $fData->save();
        $notification = array(
            'message' => 'Reject Order Successfully',
            'alert-type' => 'success'
        );
        return Redirect()->back()->with($notification);
    }

    public function InProgressOrder()
    {
        $datas =  DB::table('assign_tables')
            ->join('orders', 'assign_tables.order_id', '=', 'orders.id')
            ->join('service_types', 'assign_tables.service_type_id', '=', 'service_types.id')
            ->select(
                'assign_tables.*',
                'orders.apps_link',
                'orders.file',
                'orders.platform',
                'orders.perday',
                'orders.geo',
                'orders.order_unique_id',
                'orders.key_word',
                'orders.comment',
                'service_types.name'
            )
            ->where('assign_tables.status', [1, 2, 3])
            ->whereIn('assign_tables.work_status', [2, 3, 4, 5, 6, 9])
            ->whereIn('assign_tables.v_work_status', [2, 3, 4, 5, 6, 9])
            ->where('ven_Emp_id', Auth::user()->id)
            ->orderby('id', 'desc')
            ->get();
        //dd($datas);
        $dataCount = DB::select('SELECT COUNT(*) AS total, works_details.assign_id id FROM works_details WHERE vandor_id = ? and status !=0 GROUP BY assign_id  ', [Auth::user()->id]);
        //dd($datas);
        return view('vendor.order.inProgress', get_defined_vars());
    }

    public function WorkDetails($id)
    {
        $country = 'https://restcountries.com/v2/all';
        $datas = WorksDetails::whereIn('status', [1, 2, 3])->where('assign_id', $id)->where('vandor_id', Auth::user()->id)->orderBy('id', 'desc')->get();
        $total = count(WorksDetails::whereIn('status', [1, 2, 3])->where('assign_id', $id)->where('vandor_id', Auth::user()->id)->whereIn('work_details_status', [2, 1])->orderBy('id', 'desc')->get());
        $assign = AssignTable::where('id', $id)->where('ven_Emp_id', Auth::user()->id)->first();
        $total_avail = count(WorksDetails::whereIn('status', [1, 2, 3])->where('assign_id', $id)->where('vandor_id', Auth::user()->id)->whereIn('work_details_status', [2, 1, 3, 4, 5])->orderBy('id', 'desc')->get());

        //dd($assign->total_quantity);

        if ($assign != null) {
            $Orders = Order::find($assign->order_id);
            return view('vendor.work.workDetails', get_defined_vars());
        } else {
            return view('admin.404');
        }
    }

    public function StoreWorkDetails(Request $request)
    {
        //dd($request->all());
        $order = Order::find($request->order_id);
        //dd($order);
        $find_id = WorksDetails::orderBy('id', 'desc')->first();
        if ($find_id != null) {
            $find_value = $find_id->id;
            $uniqueId = 90000 + $find_value;
        } else {
            $uniqueId = 90000;
        }
        $work = new WorksDetails();
        $work->work_details_u_id = $uniqueId;
        $work->vandor_id = $request->vandor_id;
        $work->order_id = $request->order_id;
        $work->assign_id = $request->assign_id;
        $work->link = $request->link;
        $work->reiew_discription = $request->reiew_discription;
        $work->ratting = $request->ratting;
        $work->title = $request->title;
        $work->posting_status = $request->posting_status;
        $work->service_type_id = $order->service_type_id;
        $work->user_name = $request->user_name;
        $work->work_details_status = 1;

        $work->status = 1;
        $work->created_by = Auth::user()->id;
        $work->save();


        if ($work->id != null) {
            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->works_details_id = $work->id;
            $fData->comment = "Work Add";
            $fData->status = 1;
            $fData->save();


            $notification = array(
                'message' => 'Work Added Successfully ',
                'alert-type' => 'success'
            );
            //Check work complete or not

            $workCount = count(WorksDetails::where('assign_id', $request->assign_id)->where('status', '!=', 0)->get());
            $assign = AssignTable::find($request->assign_id);
            if ($workCount == $assign->total_quantity) {
                AssignTable::where('id', $request->assign_id)->update([
                    'work_status' => 4,
                    'v_work_status' => 4,
                ]);
            }
        } else {
            $notification = array(
                'message' => 'Work Not Added!!!',
                'alert-type' => 'error'
            );
        }
        return redirect()->back()->with($notification);
    }
    public function StoreWorkDetailsInstall(Request $request)
    {
        //dd($request->all());
        $order = Order::find($request->order_id);
        //dd($order);
        $find_id = WorksDetails::orderBy('id', 'desc')->first();
        if ($find_id != null) {
            $find_value = $find_id->id;
            $uniqueId = 90000 + $find_value;
        } else {
            $uniqueId = 90000;
        }

        $work = new WorksDetails();
        $work->work_details_u_id = $uniqueId;
        $work->vandor_id = $request->vandor_id;
        $work->order_id = $request->order_id;
        $work->assign_id = $request->assign_id;

        $work->install_date = $request->date;
        $work->keyword = $request->keyword;
        $work->country = $request->country;
        $work->country_code = $request->c_code;
        $work->os_version = $request->os;
        $work->idfa = $request->idfa;
        $work->ip = $request->ip;
        $work->service_type_id = $order->service_type_id;

        $work->work_details_status = 1;
        $work->status = 1;
        $work->created_by = Auth::user()->id;
        $work->created_date = Carbon::now();
        $work->save();


        if ($work->id != null) {
            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->works_details_id = $work->id;
            $fData->comment = "Work Add";
            $fData->status = 1;
            $fData->save();


            $notification = array(
                'message' => 'Work Added Successfully ',
                'alert-type' => 'success'
            );
            //Check work complete or not

            $workCount = count(WorksDetails::where('assign_id', $request->assign_id)->where('status', '!=', 0)->get());
            $assign = AssignTable::find($request->assign_id);
            if ($workCount == $assign->total_quantity) {
                AssignTable::where('id', $request->assign_id)->update([
                    'work_status' => 4,
                    'v_work_status' => 4,
                ]);
            }
        } else {
            $notification = array(
                'message' => 'Work Not Added!!!',
                'alert-type' => 'error'
            );
        }
        return redirect()->back()->with($notification);
    }
    public function UpdateWorkDetails(Request $request)
    {
        //dd($request->all());
        $order = Order::find($request->order_id);
        //dd($order);

        $work = WorksDetails::find($request->work_id);

        if ($order->service_type_id != 3) {
            $work->link = $request->link;
            $work->reiew_discription = $request->reiew_discription;
            $work->ratting = $request->ratting;
            $work->user_name = $request->user_name;
            $work->posting_status = $request->posting_status;
            $work->title = $request->title;
        } else {
            $work->install_date = $request->date;
            $work->keyword = $request->keyword;
            $work->country = $request->country;
            $work->country_code = $request->c_code;
            $work->os_version = $request->os;
            $work->idfa = $request->idfa;
            $work->ip = $request->ip;
        }
        $work->work_details_status = 1;
        $work->status = 1;
        $work->updated_by = Auth::user()->id;
        $work->updated_date = Carbon::now();
        $work->save();


        if ($work->id != null) {
            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->works_details_id = $work->id;
            $fData->comment = "Work Add";
            $fData->status = 1;
            $fData->save();


            $notification = array(
                'message' => 'Work Updated Successfully ',
                'alert-type' => 'success'
            );
            //Check work complete or not

            $workCount = count(WorksDetails::where('assign_id', $request->assign_id)->where('status', '!=', 0)->get());
            $assign = AssignTable::find($request->assign_id);
            if ($workCount == $assign->total_quantity) {
                if ($order->order_status == 5) {
                    AssignTable::where('id', $request->assign_id)->update([
                        'work_status' => 6,
                        'v_work_status' => 6,
                    ]);
                } else {
                    AssignTable::where('id', $request->assign_id)->update([
                        'work_status' => 4,
                        'v_work_status' => 4,
                    ]);
                }
            }
        } else {
            $notification = array(
                'message' => 'Work Not Updated !!!',
                'alert-type' => 'error'
            );
        }
        return redirect()->back()->with($notification);
    }

    public function UpdateStatus(Request $request)
    {
        AssignTable::where('id', $request->id)->update([
            'work_status' => $request->value,
            'v_work_status' => $request->value,
        ]);
        $getData = AssignTable::where('id', $request->id)->first();


        if ($request->value == 3) {
            Order::where('id', $getData->order_id)->update([
                'order_status' => 3,
            ]);
        }
        //alert($getData);
        echo json_encode($getData);
    }

    public function deleteWorkDetails($id)
    {
        WorksDetails::where('id', $id)->update([
            'status' => 0,
            'work_details_status' => 4,
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->works_details_id = $id;
        $fData->comment = "Work Details Deleted";
        $fData->status = 0;
        $fData->save();

        $notification = array(
            'message' => 'Work Details Deleted Successfully',
            'alert-type' => 'success'
        );
        return Redirect()->back()->with($notification);
    }

    public function OrderList()
    {
        $datas =  DB::table('assign_tables')
            ->join('orders', 'assign_tables.order_id', '=', 'orders.id')
            ->join('service_types', 'assign_tables.service_type_id', '=', 'service_types.id')
            ->select(
                'assign_tables.*',
                'orders.apps_link',
                'orders.file',
                'orders.platform',
                'orders.perday',
                'orders.geo',
                'orders.order_unique_id',
                'service_types.name'
            )
            ->where('assign_tables.status', [1, 2, 3])
            ->whereIn('assign_tables.work_status', [2, 3, 4, 5, 6, 7, 9, 8, 10])
            ->whereIn('assign_tables.v_work_status', [2, 3, 4, 5, 6, 7, 9, 8, 10])
            ->where('ven_Emp_id', Auth::user()->id)
            ->orderBy('id', 'desc')
            ->get();
        //dd($datas);
        $dataCount = DB::select('SELECT COUNT(*) AS total, works_details.assign_id id FROM works_details WHERE vandor_id = ? and status !=0 GROUP BY assign_id  ', [Auth::user()->id]);
        //dd($datas);
        return view('vendor.order.orderList', get_defined_vars());
    }


    public function RejectedOrders()
    {
        $datas =  DB::table('assign_tables')
            ->join('orders', 'assign_tables.order_id', '=', 'orders.id')
            ->join('service_types', 'assign_tables.service_type_id', '=', 'service_types.id')
            ->select('assign_tables.*', 'orders.apps_link', 'orders.file', 'orders.platform', 'orders.perday', 'orders.geo', 'orders.order_unique_id', 'service_types.name')
            ->where('assign_tables.status', [1, 2, 3])
            ->whereIn('assign_tables.work_status', [8])
            ->whereIn('assign_tables.v_work_status', [8])
            ->where('ven_Emp_id', Auth::user()->id)
            ->get();

        //$workers = User::whereIn('status',[1,2,3])->whereIn('role',[4,6])->get();
        //dd($datas);
        return view('vendor.order.rejectedOrder', get_defined_vars());
    }
    public function CompleteOrders()
    {
        $datas =  DB::table('assign_tables')
            ->join('orders', 'assign_tables.order_id', '=', 'orders.id')
            ->join('service_types', 'assign_tables.service_type_id', '=', 'service_types.id')
            ->select(
                'assign_tables.*',
                'orders.apps_link',
                'orders.file',
                'orders.platform',
                'orders.perday',
                'orders.geo',
                'orders.order_unique_id',
                'service_types.name'
            )
            ->where('assign_tables.status', [1, 2, 3])
            ->where('assign_tables.work_status', 10)
            ->where('assign_tables.v_work_status', 10)
            ->where('ven_Emp_id', Auth::user()->id)
            ->get();
        //dd($datas);
        $dataCount = DB::select('SELECT COUNT(*) AS total, works_details.assign_id id FROM works_details WHERE vandor_id = ? and status !=0 GROUP BY assign_id ', [Auth::user()->id]);
        //dd("Complete");
        return view('vendor.order.completedOrder', get_defined_vars());
    }

    public function editWork(Request $request)
    {
        $getData = WorksDetails::where('id', $request->id)->first();
        echo json_encode($getData);
    }

    public function fileImport(Request $request)
    {
        $find_id = WorksDetails::orderBy('id', 'desc')->first();

        if ($find_id != null) {
            $find_value = $find_id->id;
            $uniqueId = 90000 + $find_value;
        } else {
            $uniqueId = 90000;
        }

        $validator = Validator::make($request->all(), [
            'file' => 'required|mimes:xlsx|file|max:1000',
        ]);

        if ($validator->fails()) {
            $error = $validator->errors()->first();

            $notification = array(
                'message' => $error,
                'alert-type' => 'error'
            );

            return back()->with($notification);
        } else {
            Excel::import(new WorksDetailsImport($request->vandor_id, $request->order_id, $request->assign_id, $request->service_type_id, $uniqueId), request()->file('file'));

            return back();
        }
    }

    public function updatePostingStatus(Request $request)
    {
        $getData = WorksDetails::where('id', $request->id)->update([
            'posting_status' => $request->posting_status,
        ]);

        // New Update
        $findWork = WorksDetails::where('id', $request->id)->first();

        $getWorks = WorksDetails::where('vandor_id', $findWork->vandor_id)->where('assign_id', $findWork->assign_id)->get();

        $allMatch = true;
        foreach ($getWorks as $item) {
            if ($item->work_details_status != 2 || $item->posting_status != 1) {
                $allMatch = false;
                break;
            }
        }

        $findAssignOrder = AssignTable::where('id', $findWork->assign_id)->first();

        if ($allMatch) {
            $findAssignOrder->update([
                'work_status'    => 4,
                'v_work_status'  => 4,
                'posting_status' => 1,
            ]);
        } else {
            $findAssignOrder->update([
                'work_status'    => 3,
                'v_work_status'  => 3,
            ]);
        }

        // return $allMatch;

        // dd($allMatch);

        echo json_encode($getData);
    }

    public function CancelOrders()
    {
        $datas =  DB::table('assign_tables')
            ->join('orders', 'assign_tables.order_id', '=', 'orders.id')
            ->join('service_types', 'assign_tables.service_type_id', '=', 'service_types.id')
            ->select(
                'assign_tables.*',
                'orders.apps_link',
                'orders.file',
                'orders.platform',
                'orders.perday',
                'orders.geo',
                'orders.order_unique_id',
                'service_types.name'
            )
            ->where('assign_tables.status', [1, 2, 3])
            ->where('assign_tables.work_status', 11)
            ->where('assign_tables.v_work_status', 11)
            ->where('ven_Emp_id', Auth::user()->id)
            ->get();
        //dd($datas);
        $dataCount = DB::select('SELECT COUNT(*) AS total, works_details.assign_id id FROM works_details WHERE vandor_id = ? and status !=0 GROUP BY assign_id ', [Auth::user()->id]);
        //dd("Complete");
        return view('vendor.order.cancelOrder', get_defined_vars());
    }
}
