<?php

namespace App\Http\Controllers\supervisor;

use App\Models\Order;
use App\Models\WorkCheck;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class SupervisorController extends Controller
{
    
    public function index()
    {
        $id = Auth::user()->id;
        $datas = DB::table('assign_tables')
                ->join('work_checks', 'assign_tables.id', '=', 'work_checks.assign_id')
                ->select('assign_tables.*')
                ->where('work_checks.assign_id','!=',null)
                ->where('work_checks.work_type',1)
                ->where('work_checks.emp_id',$id)
                ->whereIn('work_checks.status',[1,2,3,4])
                ->where('assign_tables.work_status','!=',10)
                ->get();
    //dd($datas);

      return view('supervisor.viewCheckOrder',get_defined_vars());
    }

    
    
   
    public function show()
    {
        $id = Auth::user()->id;
        $datas =  DB::table('assign_for_texts')
                    ->join('orders', 'assign_for_texts.order_id', '=', 'orders.id')
                    ->join('service_types', 'orders.service_type_id', '=', 'service_types.id')
                    ->select('orders.*','service_types.name as s_name')
                    ->where('assign_for_texts.worker_id',$id)
                    ->where('orders.order_status','!=',10)
                    ->orderby('id','desc')
                    ->get();    
        //dd($datas);

        
        return view('supervisor.addText',get_defined_vars());
       
    }

   
    public function getValueFromOrder(Request $request)
    {
        $getData=Order::where('id',$request->id)->first();
        //alert($getData);
        echo json_encode($getData);
    }

  
    public function update(Request $request, $id)
    {
        //
    }

   
    public function destroy($id)
    {
        //
    }
}
