<?php

namespace App\Http\Controllers\employee;

use App\Models\User;
use App\Models\AssignTable;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\EmployeeSalary;

class EmployeeProfileController extends Controller
{
    public function index($id)
    {
        $findUser = User::where('id',$id)->whereIn('role', [2,5,6])->first();
        if($findUser != null ){
            $findEmployee = User::where('id', $id)->first();

            $totalEarn = EmployeeSalary::where('employee_id', $id)->whereIn('status',[1,2,3])->sum('total_salary');

            $totalOrder = AssignTable::where('ven_Emp_id', $id)
                        ->whereIn('status', [1,2,3])
                        ->whereIn('work_status', [2,3,4,5,6,7,9])
                        ->count('id');

            $completeOrder = AssignTable::where('ven_Emp_id', $id)
                        ->whereIn('status', [1,2,3])
                        ->whereIn('work_status', [4,6])
                        ->count('id');

            $currentOrder = AssignTable::where('ven_Emp_id', $id)
                        ->whereIn('status', [1,2,3])
                        ->whereIn('work_status', [2,3,5,9])
                        ->count('id');


            $total = DB::select('SELECT COUNT(works_details.id) as total, works_details.order_id as o_id FROM works_details WHERE `status` !=0 GROUP BY works_details.order_id');
            // dd($total);
            $findAsignOrder = AssignTable::where('ven_Emp_id', $id)
                            ->whereIn('status', [1,2,3])
                            ->whereIn('work_status', [2,3,5,6,9])
                            ->get();

            return view('admin.index.employeeDashboard.employeeDashboard', get_defined_vars());
        }else{
            return view('admin.404');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
