<?php

namespace App\Http\Controllers\configuration;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SidebarController extends Controller
{
    // User Acccess Configuration
    public function useraccess()
    {
        // $userlist = User::whereIn('role', [1,2,5])->get();
        // dd($userlist);
        return view('admin/configuration/userAccess/manageUserAccess', get_defined_vars());
    }

    // Admin User Acccess
    public function adminUserAccess()
    {
        $userlist = User::whereIn('role', [1,2,5])->get();
        // dd($userlist);
        return view('admin/configuration/userAccess/adminUserAccess', get_defined_vars());
    }

    // Clients User Acccess
    public function clientsUserAccess()
    {
        $userlist = User::where('role', 3)->get();
        // dd($userlist);
        return view('admin/configuration/userAccess/clientUserAccess', get_defined_vars());
    }

    // Vendor User Acccess
    public function vendorUserAccess()
    {
        $userlist = User::where('role', 4)->get();
        // dd($userlist);
        return view('admin/configuration/userAccess/vendorUserAccess', get_defined_vars());
    }

    // Employee User Acccess
    public function employeeUserAccess()
    {
        $userlist = User::where('role', 6)->get();
        // dd($userlist);
        return view('admin/configuration/userAccess/employeeUserAccess', get_defined_vars());
    }


    public function get_menu_list(Request $request)
    {
        $user_id = $request->user_id;
        $findUser = User::where('id', $request->user_id)->first();
        // echo($findUser->role);

        if($findUser != null ){
            if($findUser->role == 1 || $findUser->role == 2 ){
                $navigationList = DB::table('navigation')
                    ->select('*')
                    ->where('parent_id', 0)
                    ->where('user_type', 'administration')
                    ->get();
            }

            elseif($findUser->role == 5){
                $navigationList = DB::table('navigation')
                    ->select('*')
                    ->where('parent_id', 0)
                    ->where('target', 'supervisor')
                    ->where('user_type', 'administration')
                    ->get();
            }

            elseif($findUser->role == 3){
                $navigationList = DB::table('navigation')
                    ->select('*')
                    ->where('parent_id', 0)
                    ->where('user_type', 'clients')
                    ->get();

            }

            elseif($findUser->role == 4){
                $navigationList = DB::table('navigation')
                    ->select('*')
                    ->where('parent_id', 0)
                    ->where('user_type', 'vendor')
                    ->get();

            }

            elseif($findUser->role == 6){
                $navigationList = DB::table('navigation')
                    ->select('*')
                    ->where('parent_id', 0)
                    ->where('user_type', 'employee')
                    ->get();

            }
            // echo $navigationList;

            return view('admin/configuration/menuListShow', get_defined_vars());
        }else{
            return view('admin.404');
        }
    }
    public function insert_menu_accessList(Request $request)
    {
        $pid = array();
        $user_id = $request->user_id;
        $navigation = $request->navigation;
        DB::table('admin_role')->where('admin_id', $user_id)->delete();
        if($navigation != null){
            foreach ($navigation as $key => $value):
                $get_parent_id = DB::table('navigation')->where('navigation_id', $value)->first();
                DB::table('admin_role')->insert([
                    'admin_id' => $user_id,
                    'navigation_id' => $value,
                    'parent_id' => $get_parent_id->parent_id,
                    'url' => $get_parent_id->url,
                ]);

            endforeach;
            $request->session();
        }

        $notification= array(
            'message' =>'Admin Data updated !',
            'alert-type'=>'success'
        );
        return redirect()->back()->with($notification);
    }
    public function adminMenu()
    {
        $mainMenu = DB::table('navigation')->where('parent_id', 0)->get();
        return view('admin/configuration/menuadd', get_defined_vars());
    }
    public function storeMenu(Request $request)
    {
        if (empty($request->label) || $request->label == null) {
            return redirect('adminMenu')->with('label', 'label Can not be empty !');
        }

        if (!empty($request->parent_id)):
            $valueCheck = DB::table('navigation')->where('url', $request->url)->first();
            if (!empty($valueCheck)) {
                return redirect('adminMenu')->with('alert', 'This url already exist !');
            }

            DB::table('navigation')->insert(
                array(
                    'url' => $request->url,
                    'parent_id' => $request->parent_id,
                    'label' => $request->label,
                    'icon' => 'far fa-circle nav-icon',
                    'user_type' => $request->user_type,
                    'active' => 1,
                    'orderBy' => 1, // it can be dynamic       'object_class' =>'', // it can be dynamic
                    'object_class' => ' ', // it can be dynamic
                    'object_id' => ' ', // it can be dynamic
                    'extra_attribute' => ' ', // it can be dynamic
                    'target' => ' ', // it can be dynamic

                )
            );
        else:
            //dd($request->all());
            DB::table('navigation')->insert(
                array(
                    'url' => '',
                    'parent_id' => 0,
                    'label' => $request->label,
                    'icon' => 'fa fa-cog fa-spin',
                    'user_type' => $request->user_type,
                    'active' => 1,
                    'orderBy' => 1, // it can be dynamic
                    'object_class' => ' ', // it can be dynamic
                    'object_id' => ' ', // it can be dynamic
                    'extra_attribute' => ' ', // it can be dynamic
                    'target' => ' ', // it can be dynamic
                )
            );
        endif;

        return redirect('adminMenu');
    }
}
