<?php

namespace App\Http\Controllers\client;

use App\Models\User;
use App\Models\Order;
use App\Models\Accounts;
use App\Models\RiskFund;
use App\Models\FootPrint;
use App\Models\AssignTable;
use App\Models\ServiceType;
use App\Models\WorksDetails;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Mail\CompleteOrderMail;
use Illuminate\Support\Facades\DB;
use App\Imports\WorksDetailsImport;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;


class ClientOrderController extends Controller
{

    public function store(Request $request)
    {
        //dd($request->all());
        $validator=Validator::make($request->all(), [
            'apps_link' => 'required',
            'service_type_id' => 'required',
            'service_cost' => 'required',
            'start_date' => 'required',
            'target_date' => 'required',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'You can not add same company multiple times, Only you can update it.',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        }
        else {

        $find_id = Order::orderBy('id','desc')->first();
        if($find_id != null){
            $find_value = $find_id->id;
           $uniqueId = 10000+$find_value;
        }
        else{
            $uniqueId = 10000;
        }

        $data=new Order();
        $data->order_unique_id = $uniqueId;
        $data->apps_link = $request->apps_link;
        $data->platform = $request->platform;
        $data->service_type_id = $request->service_type_id;
        $data->total_quantity = $request->total_quantity;
        $data->service_cost = $request->service_cost;
        $data->total_budget = $request->total_budget;
        $data->perday = $request->perday;
        $data->key_word = $request->key_word;
        $data->geo = $request->geo;
        $data->order_status =1;
        $data->assigned_quantity =0;
        $data->available_quantity = $request->total_quantity;
        $data->comment = $request->comment;
        $data->workCount =0;
        $data->order_creator_id = Auth::user()->id;
        $data->total_pay = 0;
        $data->total_due = $request->total_budget;

        $data->start_date = date('Y-m-d', strtotime($request->start_date));
        $data->target_date = date('Y-m-d', strtotime($request->target_date));

        if ($request->file('file')) {
            $file = $request->file('file');
            $filename = date('YmdHi').$file->getClientOriginalName();
            $file->move(public_path('upload/orderFile'),$filename);
            $data['file'] = $filename;
        }
        $data->status = 1;
        $data->created_by = Auth::user()->id;
        $data->created_date = Carbon::now();
        $data->save();

        if($data->id != null){
            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->order_id = $data->id;
            $fData->comment = "Order Inserted";
            $fData->status = 1;
            $fData->save();

            $notification= array(
                'message' =>'Order Placed Successfully',
                'alert-type'=>'success'
            );
        }else{
            $notification= array(
                'message' =>'Order Not Placed !!!',
                'alert-type'=>'error'
            );
        }
      }
        return redirect()->route('orderList')->with($notification);
    }

    public function orderList()
    {
        $datas = Order::whereIn('status',[1,2,3])->where('order_creator_id',Auth::user()->id)->whereIn('order_status',[1,2,3,4,5,6,7,9])->orderBy('id','desc')->get();
        $accept = Order::whereIn('status',[1,2,3])->where('order_creator_id',Auth::user()->id)->where('order_status',2)->orderBy('id','desc')->get();
        $finished = Order::whereIn('status',[1,2,3])->where('order_creator_id',Auth::user()->id)->where('order_status',10)->orderBy('id','desc')->get();
        $pending = Order::whereIn('status',[1,2,3])->where('order_creator_id',Auth::user()->id)->where('order_status',1)->orderBy('id','desc')->get();
        $progress = Order::whereIn('status',[1,2,3])->where('order_creator_id',Auth::user()->id)->whereIn('order_status',[3,9])->orderBy('id','desc')->get();
        $reject = Order::whereIn('status',[1,2,3])->where('order_creator_id',Auth::user()->id)->where('order_status',8)->orderBy('id','desc')->get();
        $hold = Order::whereIn('status',[1,2,3])->where('order_creator_id',Auth::user()->id)->where('order_status',7)->orderBy('id','desc')->get();

        $service = ServiceType::whereIn('status',[1,2,3])->get();
        //dd($data);
        return view('client.order.orderTab',get_defined_vars());
    }

    public function CheckWork($id)
    {
        $Orders = Order::where('id',$id)->where('order_creator_id',Auth::user()->id)->first();

        if($Orders != null){

            $first_assign_order = AssignTable::where('order_id', $id)->first();
            // dd($first_assign_order);
            $datas = WorksDetails::whereIn('status',[1,2,3])->where('order_id',$id)->orderBy('id','desc')->get();
            $total = count( WorksDetails::whereIn('status',[1,2,3])->where('order_id',$id)->whereIn('work_details_status',[1,2])->orderBy('id','desc')->get());
            //dd($datas);
            return view('client.order.checkWork.checkWork',get_defined_vars());
        }else{
            return view('admin.404');
        }

    }

    public function CheckCompleteWork($id)
    {
        $Orders = Order::where('id',$id)->where('order_creator_id',Auth::user()->id)->first();

        if($Orders != null){

            $datas = WorksDetails::whereIn('status',[1,2,3])->where('order_id',$id)->orderBy('id','desc')->get();
            $total = count( WorksDetails::whereIn('status',[1,2,3])->where('order_id',$id)->whereIn('work_details_status',[1,2])->orderBy('id','desc')->get());
            //dd($datas);
        return view('client.order.viewCompleteOrdersWorks',get_defined_vars());
        }else{
            return view('admin.404');
        }

    }

    public function updateWorkDetailsStatusC(Request $request)
    {
        WorksDetails::where('id',$request->id)->update([
                    'work_details_status'=>$request->p_status,
        ]);
        $getData=WorksDetails::where('id',$request->id)->first();
        //alert($getData)

        if($request->p_status == 3 ||$request->p_status == 4 ||$request->p_status == 5)
        {
            $adata = AssignTable::find($getData->assign_id);
            $adata->total_earn = $adata->total_earn -  $adata->vendor_rate;
            // $adata->total_due = $adata->total_due -  $adata->vendor_rate;
            $adata->save();

            $data = Order::find($getData->order_id);
            $data->workCount = $data->workCount -  1;
            $data->order_status = 5;
            $data->save();
        }

        $checkData = AssignTable::find($getData->assign_id);
        $checkData->work_status = 5;
        $checkData->save();

        echo json_encode($getData);
    }

    public function updateOrderStatusClient(Request $request)
    {

        if($request->value == 7 || $request->value == 11)
        {
            $total = DB::select('SELECT COUNT(id)as total, assign_id FROM works_details WHERE order_id =? AND work_details_status BETWEEN 1 and 2 GROUP BY assign_id',[$request->id]);

            foreach($total as $total_data)
            {
                $findAssign = AssignTable::find($total_data->assign_id);
                $total_o_w = WorksDetails::where('assign_id',$total_data->assign_id)->whereIn('status',[1,2,3])->whereIn('work_details_status',[1,2])->count('id');
                $current_due = ($total_o_w*$findAssign->vendor_rate - $findAssign->total_pay);

                AssignTable::where('id', $total_data->assign_id)->update([
                    'work_status'=>$request->value,
                    'v_work_status'=>$request->value,
                    'complete_work'=>$total_data->total,
                    'total_due'=>$current_due,
                ]);
            }
            $order = Order::find($request->id);
            $total_o_w = WorksDetails::where('order_id',$request->id)->whereIn('status',[1,2,3])->whereIn('work_details_status',[1,2])->count('id');
            $current_due = ($total_o_w*$order->service_cost - $order->total_pay);

            Order::where('id',$request->id)->update([
                'order_status'=>$request->value,
                'total_due'=>$current_due,
            ]);
            AssignTable::where('order_id',$request->id)->update([
                'work_status'=>$request->value,
                'v_work_status'=>$request->value,
            ]);
        }
        elseif($request->value == 1){
            $order = Order::find($request->id);
            $current_due = ($order->total_budget - $order->total_pay);

            Order::where('id',$request->id)->update([
                'order_status'=>$request->value,
                'total_due'=>$current_due,
                'notify'=>"From Hold",
            ]);

            AssignTable::where('order_id',$request->id)->update([
                'work_status'=>$request->value,
                'v_work_status'=>$request->value,
                'notify'=>"From Hold",
            ]);
        }
        else
        {
            AssignTable::where('order_id',$request->id)->update([
                'work_status'=>$request->value,
                'v_work_status'=>$request->value,
                'notify'=>null,
            ]);
            Order::where('id',$request->id)->update([
                'order_status'=>$request->value,
                'notify'=>null,
            ]);
        }


        $getData=Order::where('id',$request->id)->first();
        //alert($getData);

        // Send Mail for complete Status
        $getOrder = Order::where('id',$request->id)->first();
        $getAssignTable = AssignTable::where('order_id',$request->id)->first();
        $getVendor = User::where('id', $getAssignTable->ven_Emp_id)->first();

        Mail::to(Auth::user()->email)->send(new CompleteOrderMail($getOrder, $getVendor));
        Mail::to($getVendor->email)->send(new CompleteOrderMail($getOrder, $getVendor));
        mail::to("support@proreviewapp.com")->send(new CompleteOrderMail($getOrder, $getVendor));

        //Risk Fund Update When Project Complete
        if($request->value == 10)
        {
            $accountsTotal = Accounts::first();
            $findOrderDetails = Order::where('id', $request->id)->first();

            if($findOrderDetails->order_status == 10 && $findOrderDetails->total_budget == $findOrderDetails->total_pay){

                $getTotalCost = AssignTable::where('order_id', $request->id)->sum('total_service_cost');

                $profit = $findOrderDetails->total_budget - $getTotalCost;

                $findRiskFund = RiskFund::first();
                $percentage = ($profit * 5) / 100 ;
                $totalRiskFund = $findRiskFund->total + $percentage;

                if($totalRiskFund < 300 ){
                    $Credit = $findRiskFund->credit + $percentage;
                    $totalFund = $findRiskFund->total + $percentage;

                    RiskFund::find(1)->update([
                        'credit'=> $Credit,
                        'total'=> $totalFund,
                    ]);

                    $totalCredit = $accountsTotal->credit - $percentage;
                    $totalAmount = $accountsTotal->total - $percentage;
                    // dd($totalCredit);
                    Accounts::find(1)->update([
                        'credit'=> $totalCredit,
                        'total'=> $totalAmount,
                    ]);

                }else{

                    $riskAmount = $totalRiskFund - 300 ;
                    $Credit = $findRiskFund->credit + $percentage - $riskAmount;
                    $totalFund = $findRiskFund->total + $percentage - $riskAmount;

                    RiskFund::find(1)->update([
                        'credit'=> $Credit,
                        'total'=> $totalFund,
                    ]);

                    $totalCredit = $accountsTotal->credit  - ($percentage - $riskAmount);
                    $totalAmount = $accountsTotal->total  - ($percentage - $riskAmount);
                    // dd($totalCredit);
                    Accounts::find(1)->update([
                        'credit'=> $totalCredit,
                        'total'=> $totalAmount,
                    ]);
                }
            }
        }
        echo json_encode($getData);
    }

    public function editOrder(Request $request)
    {
        $getData=Order::where('id',$request->id)->first();
        //alert($getData);
        echo json_encode($getData);
    }

    public function updateOrder(Request $request)
    {
        $data = Order::find($request->order_id);
        $data->apps_link = $request->apps_link;
        $data->platform = $request->platform;
        $data->service_type_id = $request->service_type_id;
        $data->total_quantity = $request->total_quantity;
        $data->service_cost = $request->service_cost;
        $data->total_budget = $request->total_budget;
        $data->perday = $request->perday;
        $data->key_word = $request->key_word;
        $data->geo = $request->geo;
        $data->available_quantity = $request->total_quantity-$data->assigned_quantity;
        $data->comment = $request->comment;
        $data->total_due = $request->total_budget;
        $data->start_date = date('Y-m-d', strtotime($request->start_date));
        $data->target_date = date('Y-m-d', strtotime($request->target_date));

        if ($request->file('file')) {
            @unlink(public_path('upload/orderFile/'.$data->file));
            $file = $request->file('file');
            $filename = date('YmdHi').$file->getClientOriginalName();
            $file->move(public_path('upload/orderFile'),$filename);
            $data['file'] = $filename;
        }
        $data->status = 2;
        $data->updated_by = Auth::user()->id;
        $data->updated_date = Carbon::now();
        $data->save();

        if($data->id !=null){
            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->order_id = $data->id;
            $fData->comment = "Order Updated";
            $fData->status = 2;
            $fData->save();

        $notification= array(
            'message' =>'Order Updated Successfully',
            'alert-type'=>'success'
        );
        }else{
            $notification= array(
                'message' =>'Order Not Updated !!!',
                'alert-type'=>'error'
            );
        }
        return redirect()->route('orderList')->with($notification);
    }

    public function updateOrderStatusWR(Request $request)
    {
        WorksDetails::where('id',$request->id)->update([
                    'work_details_status'=>$request->p_status,
                ]);
        $getData=WorksDetails::where('id',$request->id)->first();
        //alert($getData)

        if($request->p_status == 3 ||$request->p_status == 4 ||$request->p_status == 5)
        {
            $adata = AssignTable::find($getData->assign_id);
            $adata->total_earn = $adata->total_earn -  $adata->vendor_rate;
            // $adata->total_due = $adata->total_due -  $adata->vendor_rate;
            $adata->save();
        }
        $checkData = AssignTable::find($getData->assign_id);
        $checkData->work_status = 5;
        $checkData->save();

        echo json_encode($getData);
    }

    public function updateStatusOfOrder(Request $request)
    {
        // dd($request->all());
        Order::where('id',$request->id)->update([
                    'order_status'=>$request->value,
                    'reason'=>$request->rsn,
        ]);


        $getData=Order::where('id',$request->id)->first();
        //alert($getData);
        echo json_encode($getData);
    }
    public function deleteFileFromOrder(Request $request)
    {
        // dd($request->all());
        Order::where('id',$request->id)->update([
                    'file'=>null,
        ]);
        $getData=Order::where('id',$request->id)->first();
        //alert($getData);
        echo json_encode($getData);
    }

    public function canceleOrder()
    {
        $datas = Order::whereIn('status',[1,2,3])->where('order_creator_id',Auth::user()->id)->where('order_status',11)->orderBy('id','desc')->get();
        if($datas !=null){
            return view('client.order.viewCanceleOrder',get_defined_vars());
        }else{
            return view('admin.404');
        }

    }
}